package com.elitesland.scp.utils.excel;

import com.elitesland.scp.utils.excel.listener.DchExcelDataListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * <p>
 * 功能说明
 * </p >
 *
 * @author niu.chen
 * @date 2020/7/13
 */
@Slf4j
public class DchExcelColumnCheckUtil {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger( DchExcelDataListener.class);


    /***字符串验证 如果有长度条件就验证,  如果没有就按40验证***/
    public static boolean CheckStringlength(String value, String type) {
        String checkSvr = getCheckStr(type);
        if (checkSvr != null && StringUtils.isNumeric(checkSvr)) {
            if (value.length() > Integer.valueOf(checkSvr)) {
                return false;
            } else {
                return true;
            }
        } else {
            if (value.length() > 40) {
                return false;
            } else {
                return true;
            }
        }

    }

    /****整形校验****/
    public static boolean CheckIntegerLength(String value, String columnType) {
        if (!StringUtils.isNumeric(value)) {
            return false;
        }
        String checkSvr = getCheckStr(columnType);
        Boolean checkBoo = true;
        if (checkSvr != null && StringUtils.isNumeric(checkSvr)) {
            if (value.length() > Integer.valueOf(checkSvr)) {
                checkBoo = false;
            }
        } else {

        }
        return checkBoo;
    }

    /**
     * 浮点校验
     **/
    public static boolean CheckFloatLength(String value, String columnType) {
        if (!isNumber(value)) {
            return false;
        }
        //     String checkSvr = getCheckStr(columnType);
        //      Boolean checkBoo = true;
//        if (checkSvr != null && StringUtils.isNumeric(checkSvr)) {
//            if (value.length() > Integer.valueOf(checkSvr)) {
//                checkBoo = false;
//            }
//        } else {
//
//        }
        return true;
    }

    public static boolean checkDateTime(String value, String columnType) {
             return isCheckDateTime(value);
     }

  private  static boolean isCheckDateTime(String date_string) {

// 利用java中的SimpleDateFormat类，指定日期格式，注意yyyy,MM大小写
      SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
//      SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

// 设置日期转化成功标识
        boolean dateflag = true;
// 这里要捕获一下异常信息
        try {
            Date date = format.parse(date_string);
        } catch (Exception e) {
            LOGGER.info("context", e);
            dateflag = false;
        }
        return dateflag;
    }


    public static String getCheckStr(String columnType) {
        try {
            int index1 = columnType.indexOf("（");
            int index2 = columnType.lastIndexOf("）");
            if (index1 > -1 || index2 > -1) {
                String newStr = columnType.substring(columnType.indexOf("（") + 1, columnType.lastIndexOf("）"));
                return newStr;
            } else {
                return null;
            }
        } catch (Exception e) {
            LOGGER.info("context", e);
            return null;
        }
    }


    //正则表达式   :   完美
    public static boolean isNumber(String str) {
        String reg = "^[0-9]+(.[0-9]+)?$";
        return str.matches(reg);

    }


}
