/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.ScpsmanRegionSaveVO;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityService;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.domain.bo.ScpsmanRegionBO;
import com.elitesland.scp.domain.convert.scpsman.SalesmanInfoConvert;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.dto.authority.ScpManAuthorityDRpcSaveVO;
import com.elitesland.scp.dto.scpsman.SalesmanInfoRpcSaveVo;
import com.elitesland.scp.dto.scpsman.ScpsmanGrantedRegionDTO;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanRegionRepoProc;
import com.elitesland.scp.service.scpsman.ScpsmanRpcService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/scp/scpsman"})
public class ScpsmanRpcServiceImpl
implements ScpsmanRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpsmanRpcServiceImpl.class);
    private final ScpsmanInfoService scpsmanInfoService;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final ScpsmanRegionRepoProc scpsmanRegionRepoProc;
    private final ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc;
    private final ScpsmanAuthorityService scpsmanAuthorityService;
    private final UserRpcService userRpcService;

    @Transactional(rollbackFor={BusinessException.class})
    public ApiResult<Long> saveAndAuthority(SalesmanInfoRpcSaveVo saveVo) {
        ApiResult<ScpsmanInfoDO> scpsmanInfoDOApiResult;
        log.info("\u8ba1\u5212\u5458\u4fe1\u606f\u4fdd\u5b58RPC\u63a5\u53e3\u8c03\u7528\u5f00\u59cb\uff1a{}", (Object)JSONObject.toJSONString((Object)saveVo));
        SalesmanInfoSaveVO salesmanInfoSaveVO = SalesmanInfoConvert.INSTANCE.rpc2saveVO(saveVo);
        if (StringUtils.hasText((String)salesmanInfoSaveVO.getPhone())) {
            UserQueryDTO userQueryDTO = new UserQueryDTO();
            userQueryDTO.setMobiles(Set.of(salesmanInfoSaveVO.getPhone()));
            ApiResult userResult = this.userRpcService.queryUser(userQueryDTO);
            if (userResult.isSuccess() && CollectionUtil.isNotEmpty((Collection)((Collection)userResult.getData()))) {
                SysUserBasicDTO user = (SysUserBasicDTO)((List)userResult.getData()).get(0);
                salesmanInfoSaveVO.setSource("EMP");
                salesmanInfoSaveVO.setUserId(user.getId());
            }
        }
        if ((scpsmanInfoDOApiResult = this.scpsmanInfoService.save(salesmanInfoSaveVO)).isFailed() || scpsmanInfoDOApiResult.getData() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8ba2\u8d27\u8d26\u53f7\u4fdd\u5b58\u5931\u8d25");
        }
        ScpsmanInfoDO scpsmanInfoDO = (ScpsmanInfoDO)((Object)scpsmanInfoDOApiResult.getData());
        if (CollUtil.isNotEmpty((Collection)saveVo.getScpManAuthorityDSaveVOS())) {
            ScpsmanRegionSaveVO regionSaveVO = new ScpsmanRegionSaveVO();
            regionSaveVO.setScpsmanId(scpsmanInfoDO.getId());
            regionSaveVO.setRegionType(ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode());
            regionSaveVO.setRegionCodes(Set.of(((ScpManAuthorityDRpcSaveVO)saveVo.getScpManAuthorityDSaveVOS().get(0)).getStWhCode()));
            this.scpsmanInfoService.addRegion(regionSaveVO);
        }
        log.info("\u8ba1\u5212\u5458\u4fe1\u606f\u4fdd\u5b58RPC\u63a5\u53e3\u8c03\u7528\u7ed3\u675f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)scpsmanInfoDO)));
        return ApiResult.ok((Object)scpsmanInfoDO.getId());
    }

    public ApiResult<ScpsmanGrantedRegionDTO> getGrantedRegion(String scpsmanNo) {
        if (StrUtil.isBlank((CharSequence)scpsmanNo)) {
            return ApiResult.fail((String)"\u8ba1\u5212\u5458\u7f16\u53f7\u4e3a\u7a7a");
        }
        ScpsmanInfoDO scpsman = this.scpsmanInfoRepoProc.getByScpsmanNo(scpsmanNo);
        if (scpsman == null) {
            return ApiResult.ok();
        }
        ScpsmanGrantedRegionDTO dto = new ScpsmanGrantedRegionDTO();
        dto.setScpsmanNo(scpsmanNo);
        dto.setJurisdictionAll(Boolean.valueOf(Boolean.TRUE.equals(scpsman.getJurisdictionAll())));
        if (dto.getJurisdictionAll().booleanValue()) {
            dto.setRegionCodes(Collections.emptySet());
            dto.setStoreCodes(Collections.emptySet());
            return ApiResult.ok((Object)dto);
        }
        Map regionMap = this.scpsmanRegionRepoProc.listBoByMasId(scpsman.getId()).stream().collect(Collectors.groupingBy(ScpsmanRegionBO::getRegionType, Collectors.mapping(ScpsmanRegionBO::getRegionCode, Collectors.toSet())));
        dto.setRegionCodes(regionMap.getOrDefault(ScpUdcEnum.SCPSMAN_REGION_TYPE_REGION.getValueCode(), Collections.emptySet()));
        dto.setStoreCodes(regionMap.getOrDefault(ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode(), Collections.emptySet()));
        return ApiResult.ok((Object)dto);
    }

    public ScpsmanRpcServiceImpl(ScpsmanInfoService scpsmanInfoService, ScpsmanInfoRepoProc scpsmanInfoRepoProc, ScpsmanRegionRepoProc scpsmanRegionRepoProc, ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc, ScpsmanAuthorityService scpsmanAuthorityService, UserRpcService userRpcService) {
        this.scpsmanInfoService = scpsmanInfoService;
        this.scpsmanInfoRepoProc = scpsmanInfoRepoProc;
        this.scpsmanRegionRepoProc = scpsmanRegionRepoProc;
        this.scpDemandAuthorityDRepoProc = scpDemandAuthorityDRepoProc;
        this.scpsmanAuthorityService = scpsmanAuthorityService;
        this.userRpcService = userRpcService;
    }
}

