/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppLoginAccountStoreProtocolRespVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStoreProtocolAgreeParamVO;
import com.elitesland.scp.application.service.app.AppStoreProtocolService;
import com.elitesland.scp.application.web.app.enums.ArticleCategory;
import com.elitesland.scp.domain.service.article.ArticleManageService;
import com.elitesland.scp.domain.vo.article.ArticleInfoPagingParam;
import com.elitesland.scp.domain.vo.article.ArticleInfoRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/store/protocol"})
@Api(value="app-\u95e8\u5e97\u767b\u9646\u534f\u8bae\u7ba1\u7406", tags={"app-\u95e8\u5e97\u767b\u9646\u534f\u8bae\u7ba1\u7406"})
public class AppStoreProtocolContorller {
    private static final Logger log = LoggerFactory.getLogger(AppStoreProtocolContorller.class);
    private final AppStoreProtocolService appStoreProtocolService;
    private final ArticleManageService articleManageService;

    @PostMapping(value={"/agree"})
    @ApiOperation(value="\u95e8\u5e97\u534f\u8bae\u540c\u610f\u72b6\u6001\u66f4\u65b0")
    public ApiResult<?> setStoreProtocolAgreeStatus(@RequestBody AppStoreProtocolAgreeParamVO param) {
        this.appStoreProtocolService.setProtocolAgreeStatus(param);
        return ApiResult.ok();
    }

    @GetMapping(value={"/search/{account}"})
    @ApiOperation(value="\u67e5\u8be2\u534f\u8bae\u72b6\u6001")
    public ApiResult<AppLoginAccountStoreProtocolRespVO> search(@PathVariable(value="account") String account) {
        return ApiResult.ok((Object)this.appStoreProtocolService.queryStoreProtocolByAccount(account));
    }

    @GetMapping(value={"/query"})
    @ApiOperation(value="\u95e8\u5e97\u534f\u8bae\u67e5\u8be2")
    public ApiResult<?> serchStoreProtocol() {
        return ApiResult.ok((Object)this.appStoreProtocolService.serchStoreProtocol());
    }

    @GetMapping(value={"/queryByCategoryName"})
    @ApiOperation(value="\u95e8\u5e97\u534f\u8bae\u901a\u8fc7\u5165\u53c2\u67e5\u8be2")
    public ApiResult<?> queryByParam(@RequestParam String categoryName) {
        return ApiResult.ok((Object)this.appStoreProtocolService.serchStoreProtocolByName(categoryName));
    }

    @PostMapping(value={"/article/search"})
    @ApiOperation(value="\u95e8\u5e97\u534f\u8bae\u6587\u6863\u5217\u8868\u53ca\u5185\u5bb9\u67e5\u8be2")
    public ApiResult<PagingVO<ArticleInfoRespVO>> articleInfoSearch(@RequestBody ArticleInfoPagingParam searchParam) {
        switch (searchParam.getCategoryCode()) {
            case "0": {
                searchParam.setCategoryName(ArticleCategory.ARTICLE_CODE_APP_STORE_PROTOCOL.getDescription());
                break;
            }
            case "1": {
                searchParam.setCategoryName(ArticleCategory.ARTICLE_CODE_PERSONAL_CENTER_PROTOCOL.getDescription());
                break;
            }
        }
        if (searchParam.getShowFlag() == null) {
            searchParam.setShowFlag("DISPLAY");
        }
        return ApiResult.ok(this.articleManageService.infoSearch(searchParam));
    }

    public AppStoreProtocolContorller(AppStoreProtocolService appStoreProtocolService, ArticleManageService articleManageService) {
        this.appStoreProtocolService = appStoreProtocolService;
        this.articleManageService = articleManageService;
    }
}

