/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.order.ScpDemandOrderExportRespVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpComputeDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpsmanAuthQueryParam;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.AppDemandOrderCountRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderComputeVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpPayOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.OrderStatusCountdownService;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderExportRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanRegionRepoProc;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandOrderDomainServiceImpl
implements ScpDemandOrderDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderDomainServiceImpl.class);
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final ScpsmanRegionRepoProc scscpsmanRegionRepoProc;
    private final OrderStatusCountdownService orderStatusCountdownService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandOrderExportRepoProc scpDemandOrderExportRepoProc;

    @Override
    public ScpDemandOrderDO saveDemandOrder(ScpDemandOrderSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpDemandOrderDO intentDO = ScpDemandOrderConvert.INSTANCE.saveVoToDO(saveVO);
            return (ScpDemandOrderDO)this.scpDemandOrderRepo.save(intentDO);
        }
        Optional option = this.scpDemandOrderRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u8ba2\u5355ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderConvert.INSTANCE.copySaveParamToDo(saveVO, (ScpDemandOrderDO)option.get());
        return (ScpDemandOrderDO)this.scpDemandOrderRepo.save((ScpDemandOrderDO)option.get());
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderTitlePageRespVO> page(ScpDemandOrderPageParamVO paramVO) {
        boolean authed = this.appendScpsmanAuth(paramVO);
        if (!authed) {
            return PagingVO.empty();
        }
        long count = this.scpDemandOrderRepoProc.countDemandOrderPage(paramVO);
        if (count > 0L) {
            List<ScpDemandOrderTitlePageRespVO> demandOrder = this.scpDemandOrderRepoProc.queryDemandOrderPage(paramVO);
            return new PagingVO(count, demandOrder);
        }
        return new PagingVO();
    }

    private boolean appendScpsmanAuth(ScpsmanAuthQueryParam paramVO) {
        String username = SecurityContextUtil.currentUserIfUnauthorizedThrow().getUsername();
        ScpsmanInfoDO scpsmanInfo = this.scpsmanInfoRepoProc.getByScpsmanNo(username);
        if (scpsmanInfo == null) {
            return false;
        }
        paramVO.setScpsmanInfoId(scpsmanInfo.getId());
        if (Boolean.TRUE.equals(scpsmanInfo.getJurisdictionAll())) {
            paramVO.setAllRegion(true);
            return true;
        }
        paramVO.setAllRegion(false);
        List<String> regionCodes = this.scscpsmanRegionRepoProc.getRegionCodesByMasId(scpsmanInfo.getId(), com.elitesland.scp.application.enums.ScpUdcEnum.SCPSMAN_REGION_TYPE_REGION.getValueCode());
        if (!regionCodes.isEmpty()) {
            OrgStoreBaseRpcParam param = new OrgStoreBaseRpcParam();
            param.setRegionList(new ArrayList<String>(regionCodes));
            List storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(param).computeData();
            if (CollUtil.isNotEmpty((Collection)storeList)) {
                paramVO.setRegionStoreCodes(storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).collect(Collectors.toSet()));
            }
        }
        return true;
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderList(ScpDemandOrderPageParamVO paramVO) {
        long count;
        boolean authed = this.appendScpsmanAuth(paramVO);
        if (!authed) {
            return PagingVO.empty();
        }
        if (CollectionUtil.isNotEmpty(paramVO.getRegionCodes())) {
            OrgStoreBaseRpcParam param = new OrgStoreBaseRpcParam();
            param.setRegionList(new ArrayList<String>(paramVO.getRegionCodes()));
            List storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(param).computeData();
            if (CollUtil.isNotEmpty((Collection)storeList)) {
                List<String> storeCodeList = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).distinct().toList();
                if (paramVO.getDemandWhStCodes() == null) {
                    paramVO.setDemandWhStCodes(storeCodeList);
                } else {
                    paramVO.getDemandWhStCodes().addAll(storeCodeList);
                }
            } else {
                return PagingVO.empty();
            }
        }
        if ((count = this.scpDemandOrderRepoProc.countDemandOrder(paramVO)) > 0L) {
            List<ScpDemandOrderPageRespVO> demandOrder = this.scpDemandOrderRepoProc.queryDemandOrder(paramVO);
            demandOrder = demandOrder.stream().peek(demandOrderPageRespVO -> demandOrderPageRespVO.setUniqueId(demandOrderPageRespVO.getDetailId() == null ? demandOrderPageRespVO.getId() : demandOrderPageRespVO.getId() + demandOrderPageRespVO.getDetailId())).toList();
            return new PagingVO(count, demandOrder);
        }
        return new PagingVO();
    }

    private List<Long> getAuthIds() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        String username = currentUserDTO.getDetail().getUsername();
        return this.scpDemandOrderRepoProc.queryIdsByAccount(username);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        paramVO.setCreateUserId(currentUserId);
        long count = this.scpDemandOrderRepoProc.countDemandOrderHeader(paramVO);
        if (count > 0L) {
            List<ScpDemandOrderPageRespVO> demandOrder = this.scpDemandOrderRepoProc.queryDemandOrderHeader(paramVO);
            List<Long> masId = demandOrder.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<ScpDemandOrderPageRespVO> orderDList = this.scpDemandOrderRepoProc.sumDemandAmt(masId);
            if (CollUtil.isEmpty(orderDList)) {
                return new PagingVO(count, demandOrder);
            }
            List<ScpDemandOrderDDTO> itemList = this.scpDemandOrderDRepoProc.findItemListByMasId(masId);
            Map<Long, List<ScpDemandOrderDDTO>> orderMap = itemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getMasId));
            Map idMap = orderDList.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            demandOrder.forEach(row -> {
                List<String> imgUrls;
                List demandOrderDDTOS;
                if (idMap.containsKey(row.getId())) {
                    ScpDemandOrderPageRespVO orderD = (ScpDemandOrderPageRespVO)idMap.get(row.getId());
                    row.setDemandSumQuantity(orderD.getDemandSumQuantity());
                    row.setDemandSumAmt(orderD.getDemandSumAmt());
                }
                if (CollUtil.isNotEmpty((Collection)(demandOrderDDTOS = (List)orderMap.get(row.getId()))) && CollUtil.isNotEmpty(imgUrls = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getImgUrl).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    row.setItemImgUrls(imgUrls);
                }
            });
            return new PagingVO(count, demandOrder);
        }
        return new PagingVO();
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDTO> findDemandOrderByIds(List<Long> ids) {
        return this.scpDemandOrderRepo.findByIdIn(ids).stream().map(ScpDemandOrderConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public Optional<ScpDemandOrderDTO> findDemandOrderById(Long id) {
        return this.scpDemandOrderRepo.findById(id).map(ScpDemandOrderConvert.INSTANCE::doToDto);
    }

    @Override
    public List<ScpDemandOrderComputeVO> getItemAndWarehouseByIds(List<Long> ids) {
        return this.scpDemandOrderRepoProc.getItemAndWarehouseByIds(ids);
    }

    @Override
    public List<ScpDemandOrderDTO> findDemandOrderByDemandIds(List<Long> demandIds) {
        return this.scpDemandOrderRepo.findByDemandIdIn(demandIds).stream().map(ScpDemandOrderConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<ScpDemandOrderDTO> findDemandOrderByParam(ScpDemandOrderParamVO paramVO) {
        return this.scpDemandOrderRepoProc.findDemandOrderByParam(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAllocStatusByDemandId(Long demandId) {
        List<ScpDemandOrderComputeVO> demandOrderComputeVOS = this.scpDemandOrderRepoProc.findDemandOrderInfo(demandId);
        ArrayList partOrPushedList = ListUtil.toList((Object[])new String[]{ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode(), ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()});
        Map<String, List<ScpDemandOrderComputeVO>> orderMap = demandOrderComputeVOS.stream().filter(row -> !partOrPushedList.contains(row.getDocStatus())).collect(Collectors.groupingBy(ScpDemandOrderComputeVO::getDocCode));
        for (Map.Entry<String, List<ScpDemandOrderComputeVO>> entry : orderMap.entrySet()) {
            long noAllocCount = entry.getValue().stream().filter(row -> row.getIsCalculated() == false).count();
            String status = noAllocCount == 0L ? ScpUdcEnum.DEO_STATUS_DONE.getValueCode() : (noAllocCount == (long)entry.getValue().size() ? ScpUdcEnum.DEO_STATUS_WT.getValueCode() : ScpUdcEnum.DEO_STATUS_DOING.getValueCode());
            Boolean isCalculated = !ScpUdcEnum.DEO_STATUS_WT.getValueCode().equals(status) ? Boolean.TRUE : Boolean.FALSE;
            this.scpDemandOrderRepoProc.updateOrderStatusByCode(entry.getKey(), status, isCalculated);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePushStatusByDemandId(Long demandId) {
        List<ScpDemandOrderComputeVO> demandOrderComputeVOS = this.scpDemandOrderRepoProc.findDemandOrderInfo(demandId);
        Map<String, List<ScpDemandOrderComputeVO>> orderMap = demandOrderComputeVOS.stream().collect(Collectors.groupingBy(ScpDemandOrderComputeVO::getDocCode));
        for (Map.Entry<String, List<ScpDemandOrderComputeVO>> entry : orderMap.entrySet()) {
            long noPushCount = entry.getValue().stream().filter(row -> row.getIsPushed() == false).count();
            String status = noPushCount == 0L ? ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode() : (noPushCount == (long)entry.getValue().size() ? "\u63a8\u9001\u4e2d" : ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode());
            if ("\u63a8\u9001\u4e2d".equals(status)) continue;
            this.scpDemandOrderRepoProc.updateOrderStatusByCode(entry.getKey(), status, null);
        }
    }

    @Override
    public List<AppDemandOrderCountRespVO> countStatus(ScpDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderRepoProc.countAppDemandOrder(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpDemandOrderRepo.deleteByIdIn(ids);
    }

    @Override
    public Long countUnPushedOrderByDemandId(Long demandId) {
        return this.scpDemandOrderRepoProc.countUnPushedItemByDemandId(demandId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAllocStatusAndPayStatusById(Long id) {
        List<ScpDemandOrderDDO> demandOrderDDOS = this.scpDemandOrderDRepo.findByMasId(id);
        if (CollUtil.isEmpty(demandOrderDDOS)) {
            return;
        }
        List noAllocItemName = demandOrderDDOS.stream().filter(row -> row.getIsCalculated() == false).map(ScpDemandOrderDDO::getItemName).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(noAllocItemName)) {
            String noAllocItemNames = String.join((CharSequence)",", noAllocItemName);
            throw new BusinessException("\u5b58\u5728\u65e0\u6cd5\u5206\u914d\u7684\u8ba2\u5355\u660e\u7ec6\u884c:" + noAllocItemNames);
        }
        String status = ScpUdcEnum.DEO_STATUS_DONE.getValueCode();
        List<String> payStatusList = List.of(ScpUdcEnum.PAY_STATUS_PART_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode());
        long needPayCount = demandOrderDDOS.stream().filter(row -> payStatusList.contains(row.getPayStatus())).count();
        long noPayCount = demandOrderDDOS.stream().filter(row -> ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode().equals(row.getPayStatus())).count();
        String payStatus = noPayCount == (long)demandOrderDDOS.size() ? ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode() : (needPayCount > 0L ? ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode() : ScpUdcEnum.PAY_STATUS_PAYED.getValueCode());
        this.scpDemandOrderRepoProc.updateOrderStatusAndPayStatusById(id, status, payStatus);
    }

    @Override
    public Long countDemandOrderByDemandIds(List<Long> demandIds) {
        return this.scpDemandOrderRepoProc.countDemandOrderByDemandIds(demandIds);
    }

    @Override
    public List<ScpDemandOrderComputeVO> findComputeDemandOrderD(List<Long> orderIds) {
        return this.scpDemandOrderRepoProc.findComputeDemandOrderDByParam(orderIds);
    }

    @Override
    public List<Long> pageDemandOrderIds(ScpComputeDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderRepoProc.pageDemandOrderIds(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDocStatusById(Long id, String type) {
        ScpDemandOrderComputeVO order;
        List<String> statusList;
        List<ScpDemandOrderDDTO> itemList = this.scpDemandOrderDRepoProc.findByMasId(id).stream().filter(row -> Boolean.FALSE.equals(row.getFreightLineFlag()) && Boolean.FALSE.equals(row.getProjectFeeFlag()) && !Objects.equals(row.getStatus(), ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode())).toList();
        if ("DELIVERY".equals(type)) {
            List recvList = itemList.stream().filter(row -> row.getRecvQty() != null && row.getRecvQty().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(recvList)) {
                return;
            }
            List noDeliverList = itemList.stream().filter(row -> row.getQuantity() == null || row.getQuantity().compareTo(BigDecimal.ZERO) == 0 || row.getQuantity().compareTo(row.getPlanQuantity()) < 0).collect(Collectors.toList());
            String status = CollUtil.isEmpty(noDeliverList) ? ScpUdcEnum.DEO_STATUS_SHIP.getValueCode() : ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode();
            this.scpDemandOrderRepoProc.updateOrderStatusById(id, status, null);
        }
        if ("RECV".equals(type)) {
            List noRecvList = itemList.stream().filter(row -> row.getRecvQty() == null || row.getRecvQty().compareTo(BigDecimal.ZERO) == 0 || row.getRecvQty().compareTo(row.getPlanQuantity()) < 0).collect(Collectors.toList());
            String status = CollUtil.isEmpty(noRecvList) ? ScpUdcEnum.DEO_STATUS_RECV.getValueCode() : ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode();
            this.scpDemandOrderRepoProc.updateOrderStatusById(id, status, null);
        }
        if ("CANCEL".equals(type)) {
            statusList = List.of(ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_RECV.getValueCode(), ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode());
            List<ScpDemandOrderComputeVO> demandOrderList = this.scpDemandOrderRepoProc.findDemandOrderById(id);
            if (CollUtil.isEmpty(demandOrderList)) {
                log.info("\u53d6\u6d88\u67e5\u8be2\u8981\u8d27\u5355\u6570\u636e\u4e3a\u7a7a:{}", (Object)id);
            }
            if (statusList.contains((order = demandOrderList.get(0)).getDocStatus())) {
                return;
            }
            long noPushCount = itemList.stream().filter(row -> row.getIsPushed() == false).count();
            String status = noPushCount == 0L ? ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode() : (noPushCount == (long)itemList.size() ? ScpUdcEnum.DEO_STATUS_DONE.getValueCode() : ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode());
            Boolean isPushed = ScpUdcEnum.DEO_STATUS_DONE.getValueCode().equals(status);
            this.scpDemandOrderRepoProc.updateOrderStatusById(id, status, isPushed);
            this.updatePayStatusById(id);
        }
        if ("ZF".equals(type)) {
            statusList = List.of(ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_RECV.getValueCode(), ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode());
            List<ScpDemandOrderComputeVO> orders = this.scpDemandOrderRepoProc.findDemandOrderById(id);
            if (CollUtil.isEmpty(orders)) {
                log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u8981\u8d27\u5355\u636e\uff1a{}", (Object)id);
                return;
            }
            order = orders.get(0);
            if (statusList.contains(order.getDocStatus())) {
                return;
            }
            List noShipList = itemList.stream().filter(row -> row.getQuantity() == null || row.getQuantity().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
            String status = CollUtil.isNotEmpty(noShipList) && noShipList.size() != itemList.size() ? ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode() : ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode();
            this.scpDemandOrderRepoProc.updateOrderStatusById(id, status, null);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePushStatusById(Long id) {
        String status;
        List<ScpDemandOrderComputeVO> demandOrderComputeVOS = this.scpDemandOrderRepoProc.findDemandOrderById(id);
        long noPushCount = demandOrderComputeVOS.stream().filter(row -> row.getIsPushed() == false).count();
        String string = noPushCount == 0L ? ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode() : (status = noPushCount == (long)demandOrderComputeVOS.size() ? "\u63a8\u9001\u4e2d" : ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode());
        if (!"\u63a8\u9001\u4e2d".equals(status)) {
            if (ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode().equals(status)) {
                LocalDateTime pushedTime = LocalDateTime.now();
                this.scpDemandOrderRepoProc.updateOrderStatusAndPushedTimeById(id, status, Boolean.TRUE, pushedTime);
                ScpDemandOrderComputeVO scpDemandOrderComputeVO = demandOrderComputeVOS.get(0);
                if (scpDemandOrderComputeVO != null && scpDemandOrderComputeVO.getAllowPayTimeout() != null && scpDemandOrderComputeVO.getAllowPayTimeout().booleanValue()) {
                    String payTimeoutSetting = SysUtils.getOrderPayTimeoutSetting();
                    long parseLong = 30L;
                    try {
                        parseLong = Long.parseLong(payTimeoutSetting);
                    }
                    catch (NumberFormatException e) {
                        log.error("\u652f\u4ed8\u8d85\u65f6\u8bbe\u7f6e\u9519\u8bef\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c30");
                    }
                    this.orderStatusCountdownService.startCountdown(id, parseLong * 60L, ScpUdcEnum.DEO_STATUS_TIMEOUT.getValueCode(), pushedTime);
                }
            } else {
                this.scpDemandOrderRepoProc.updateOrderStatusById(id, status, Boolean.TRUE);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePayStatusById(Long id) {
        List<ScpDemandOrderDDTO> demandOrderDDTOS = this.scpDemandOrderDRepoProc.findByMasId(id);
        long payedCount = demandOrderDDTOS.stream().filter(row -> ScpUdcEnum.PAY_STATUS_PAYED.getValueCode().equals(row.getPayStatus())).count();
        long waitPayCount = demandOrderDDTOS.stream().filter(row -> ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode().equals(row.getPayStatus())).count();
        long noPayCount = demandOrderDDTOS.stream().filter(row -> ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode().equals(row.getPayStatus())).count();
        if (noPayCount == (long)demandOrderDDTOS.size()) {
            this.scpDemandOrderRepoProc.updatePayStatusById(id, ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode());
        } else {
            String status = waitPayCount > 0L && payedCount == 0L ? ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode() : (payedCount == (long)demandOrderDDTOS.size() - noPayCount ? ScpUdcEnum.PAY_STATUS_PAYED.getValueCode() : ScpUdcEnum.PAY_STATUS_PART_PAY.getValueCode());
            this.scpDemandOrderRepoProc.updatePayStatusById(id, status);
        }
    }

    @Override
    public PagingVO<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO) {
        long count = this.scpDemandOrderRepoProc.countAppPayPage(paramVO);
        if (count > 0L) {
            List<ScpPayOrderPageRespVO> demandOrder = this.scpDemandOrderRepoProc.payPage(paramVO);
            List<Long> ids = demandOrder.stream().map(ScpPayOrderPageRespVO::getDocId).collect(Collectors.toList());
            Map payOrderMap = this.scpDemandOrderRepoProc.findDemandOrderByIds(ids).stream().collect(Collectors.toMap(ScpPayOrderPageRespVO::getDocId, Function.identity()));
            List<ScpDemandOrderDDTO> itemList = this.scpDemandOrderDRepoProc.findItemListByMasId(ids);
            Map<Long, List<ScpDemandOrderDDTO>> orderMap = itemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getMasId));
            demandOrder.forEach(row -> {
                List<String> imgUrls;
                ScpPayOrderPageRespVO pageRespVO = (ScpPayOrderPageRespVO)payOrderMap.get(row.getDocId());
                row.setDocCode(pageRespVO.getDocCode());
                row.setDocCls(pageRespVO.getDocCls());
                row.setDocType(pageRespVO.getDocType());
                row.setDocStatus(pageRespVO.getDocStatus());
                row.setCreateTime(pageRespVO.getCreateTime());
                List demandOrderDDTOS = (List)orderMap.get(row.getId());
                if (CollUtil.isNotEmpty((Collection)demandOrderDDTOS) && CollUtil.isNotEmpty(imgUrls = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getImgUrl).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    row.setItemImgUrls(imgUrls);
                }
            });
            return new PagingVO(count, demandOrder);
        }
        return new PagingVO();
    }

    @Override
    public AppPayOrderRespVO payOrderBySrcDocId(Long srcDocId) {
        return this.scpDemandOrderRepoProc.findPayOrderBySrcDocId(srcDocId);
    }

    @Override
    public List<AppPayOrderRespVO> payOrderById(Long id) {
        return this.scpDemandOrderRepoProc.findPayOrderById(id);
    }

    @Override
    public Long countAppOrderByParam(ScpDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderRepoProc.countAppOrderByParam(paramVO);
    }

    @Override
    public Long countAppPayOrderByParam(ScpDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderRepoProc.countAppPayPage(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateReplyFlagById(Long id) {
        this.scpDemandOrderRepo.updateReplyById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closeDemandOrder(Long id, String cancelOperator) {
        this.scpDemandOrderRepo.closeDemandOrder(id, cancelOperator);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderStatusById(Long id, String docStatus) {
        this.scpDemandOrderRepoProc.updateOrderStatusById(id, docStatus);
    }

    @Override
    public Long findIdByCode(String docCode) {
        return this.scpDemandOrderRepoProc.findIdByCode(docCode);
    }

    @Override
    public PagingVO<ScpDemandOrderExportRespVO> executeExport(ScpDemandOrderPageParamVO queryParamVO) {
        boolean authed = this.appendScpsmanAuth(queryParamVO);
        if (!authed) {
            return PagingVO.empty();
        }
        return this.scpDemandOrderExportRepoProc.executeExport(queryParamVO);
    }

    public ScpDemandOrderDomainServiceImpl(ScpDemandOrderRepo scpDemandOrderRepo, ScpDemandOrderDRepo scpDemandOrderDRepo, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc, ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpsmanInfoRepoProc scpsmanInfoRepoProc, ScpsmanRegionRepoProc scscpsmanRegionRepoProc, OrderStatusCountdownService orderStatusCountdownService, OrgStoreRpcService orgStoreRpcService, ScpDemandOrderExportRepoProc scpDemandOrderExportRepoProc) {
        this.scpDemandOrderRepo = scpDemandOrderRepo;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpsmanInfoRepoProc = scpsmanInfoRepoProc;
        this.scscpsmanRegionRepoProc = scscpsmanRegionRepoProc;
        this.orderStatusCountdownService = orderStatusCountdownService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpDemandOrderExportRepoProc = scpDemandOrderExportRepoProc;
    }
}

