/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.alloc;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingInfoRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingDO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingItemDO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingStoreDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Component;

@Component
public class ScpAllocSettingItemRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingStoreDO scpAllocSettingStoreDO = QScpAllocSettingStoreDO.scpAllocSettingStoreDO;
    private static final QScpAllocSettingDO scpAllocSettingDO = QScpAllocSettingDO.scpAllocSettingDO;
    private static final QScpAllocSettingItemDO scpAllocSettingItemDO = QScpAllocSettingItemDO.scpAllocSettingItemDO;

    public List<ScpAllocSettingItemRespVO> getAllocSettingItemByStoreCode(String storeCode, String docType, List<String> itemType2s) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpAllocSettingItemRespVO.class, (Expression[])new Expression[]{ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.id, ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.masId, ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemId, ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemCode, ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemName, ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.minNum, ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemType2, ScpAllocSettingItemRepoProc.scpAllocSettingDO.activityCode})).from((EntityPath)scpAllocSettingDO)).leftJoin((EntityPath)scpAllocSettingItemDO)).on((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.id.eq(ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.masId))).leftJoin((EntityPath)scpAllocSettingStoreDO)).on((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingStoreDO.masId.eq(ScpAllocSettingItemRepoProc.scpAllocSettingDO.id));
        jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingStoreDO.storeCode.eq((Object)storeCode));
        if (CollectionUtil.isNotEmpty(itemType2s)) {
            jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemType2.in(itemType2s));
        }
        jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingStoreDO.maxNum.gt(ScpAllocSettingItemRepoProc.scpAllocSettingStoreDO.allocNum));
        if (Strings.isNotBlank((String)docType)) {
            jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.docType.like("%" + docType + "%"));
        }
        jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime now = LocalDateTime.now();
        jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.validFrom.loe((Comparable)now).and((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.validTo.goe((Comparable)now)));
        return jpaQuery.fetch();
    }

    public List<ScpAllocSettingInfoRespVO> getAllocSettingItemByStoreCode2(String itemCode, String docType, List<String> itemType2s) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(ScpAllocSettingInfoRespVO.class, (Expression[])new Expression[]{ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.masId, ScpAllocSettingItemRepoProc.scpAllocSettingDO.validFrom, ScpAllocSettingItemRepoProc.scpAllocSettingDO.validTo, ScpAllocSettingItemRepoProc.scpAllocSettingDO.activityCode})).from((EntityPath)scpAllocSettingDO)).innerJoin((EntityPath)scpAllocSettingItemDO)).on((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.id.eq(ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.masId));
        jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemCode.eq((Object)itemCode));
        if (CollectionUtil.isNotEmpty(itemType2s)) {
            jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemType2.in(itemType2s));
        }
        if (Strings.isNotBlank((String)docType)) {
            jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.docType.like("%" + docType + "%"));
        }
        jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingDO.status.eq(Boolean.TRUE));
        return jpaQuery.fetch();
    }

    public List<Long> findMasIdByItemId(Long itemId, Set<Long> masIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.masId).distinct()).from((EntityPath)scpAllocSettingItemDO);
        jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.itemId.eq((Object)itemId));
        if (CollectionUtils.isNotEmpty(masIds)) {
            jpaQuery.where((Predicate)ScpAllocSettingItemRepoProc.scpAllocSettingItemDO.masId.in(masIds));
        }
        return jpaQuery.fetch();
    }

    public ScpAllocSettingItemRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

