package com.elitesland.scp.application.service.purLimit;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreRefreshParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingSaveVO;

import java.util.List;

public interface ScpPurLimitSettingService {

    /**
     * 起订活动查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpPurLimitSettingPageRespVO> page(ScpPurLimitSettingPageParamVO paramVO);

    /**
     * 起订活动详情查询
     *
     * @param id
     * @return
     */
    ScpPurLimitSettingRespVO findPurLimitSettingById(Long id);

    /**
     * 起订活动保存
     *
     * @param saveVO
     * @return
     */
    Long savePurLimitSetting(ScpPurLimitSettingSaveVO saveVO);

    /**
     * 删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 变更状态
     *
     * @param paramVO
     * @return
     */
    void changePurLimitSettingStatus(ScpPurLimitSettingStatusParamVO paramVO);


    List<ScpPurLimitSettingStoreRespVO> importStoreData(List<ScpPurLimitSettingImportStoreParamVO> list);

    void storeRefresh(ScpAllocSettingStoreRefreshParamVO paramVO);

}
