package com.elitesland.scp.domain.entity.supalloc;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @description: 供应商份额分配
 * @author: jeesie.jiang
 * @create: 2024-03-25
 * @Version 1.0
 **/
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_supply_allocation")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_supply_allocation", comment = "供应商份额分配")
@ApiModel(value = "供应商份额分配", description = "供应商份额分配")
public class ScpSupplyAllocationDO extends BaseModel implements Serializable {

    @Column(name = "supp_id", columnDefinition = "bigint")
    @Comment("供应仓库id")
    private Long suppId;

    @Column(name = "supp_code", columnDefinition = "varchar(64)")
    @Comment("供应商编码")
    private String suppCode;

    @Column(name = "supp_name", columnDefinition = "varchar(64)")
    @Comment("供应商名称")
    private String suppName;

    @Comment("采购公司id")
    @Column(name = "ou_id", columnDefinition = "bigint")
    private Long ouId;

    @Comment("采购公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(64)")
    private String ouCode;

    @Comment("采购公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(64)")
    private String ouName;

    @Column(name = "type", columnDefinition = "varchar(30)")
    @Comment("类型")
    private String type;

    @Column(name = "store_wh_id", columnDefinition = "bigint")
    @Comment("门店id/门店仓库id")
    private Long storeWhId;

    @Column(name = "store_wh_code", columnDefinition = "varchar(64)")
    @Comment("仓库编码/门店编码")
    private String storeWhCode;

    @Column(name = "store_wh_name", columnDefinition = "varchar(64)")
    @Comment("仓库名称/门店名称")
    private String storeWhName;

    @Column(name = "item_cate_code", columnDefinition = "varchar(64)")
    @Comment("商品品类编码")
    private String itemCateCode;

    @Column(name = "item_cate_name", columnDefinition = "varchar(64)")
    @Comment("商品品类名称")
    private String itemCateName;

    @Column(name = "item_id", columnDefinition = "bigint")
    @Comment("商品id")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(64)")
    @Comment("商品编码")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(64)")
    @Comment("商品名称")
    private String itemName;

    @Column(name = "allocation", columnDefinition = "decimal(20,8)")
    @Comment("配额")
    private BigDecimal allocation;

    @Column(name = "minimum_order_quantity", columnDefinition = "decimal(20,8)")
    @Comment("最小订货量")
    private BigDecimal minimumOrderQuantity;

    @Column(name = "purchase_lead_time", columnDefinition = "decimal(20,8)")
    @Comment("采购提前期")
    private BigDecimal purchaseLeadTime;

    @Column(name = "start_time", columnDefinition = "datetime(6)")
    @Comment("有效日期从")
    private LocalDateTime startTime;

    @Column(name = "end_time", columnDefinition = "datetime(6)")
    @Comment("有效日期至")
    private LocalDateTime endTime;

    @Column(name = "status", columnDefinition = "tinyint(1)")
    @Comment("状态true-启用，false-禁用")
    private Boolean status;

    @ApiModelProperty("行号")
    @Column(name = "line_no", columnDefinition = "int(11)  comment '行号'")
    private Integer lineNo;

    @Column(name = "sale_ou_code", columnDefinition = "varchar(40)")
    @Comment("销售公司编码")
    private String saleOuCode;

    @Column(name = "sale_ou_name", columnDefinition = "varchar(128)")
    @Comment("销售公司名称")
    private String saleOuName;

    @Column(name = "sale_cust_code", columnDefinition = "varchar(40)")
    @Comment("销售客户编码")
    private String saleCustCode;

    @Column(name = "tenant_id", columnDefinition = "bigint")
    @Comment("租户ID")
    private Long tenantId;

    @Column(name = "remark", columnDefinition = "varchar(255)")
    @Comment("备注")
    private String remark;

    @Column(name = "create_user_id", columnDefinition = "bigint")
    @Comment("记录创建者ID")
    private Long createUserId;

    @Column(name = "creator", columnDefinition = "varchar(255)")
    @Comment("记录创建者")
    private String creator;

    @Column(name = "create_time", columnDefinition = "datetime(6)")
    @Comment("记录创建时间")
    private LocalDateTime createTime;

    @Column(name = "modify_user_id", columnDefinition = "bigint")
    @Comment("记录最后更新者ID")
    private Long modifyUserId;

    @Column(name = "updater", columnDefinition = "varchar(255)")
    @Comment("记录最后更新者")
    private String updater;

    @Column(name = "modify_time", columnDefinition = "datetime(6)")
    @Comment("记录最后更新时间")
    private LocalDateTime modifyTime;

    @Column(name = "delete_flag", columnDefinition = "int")
    @Comment("记录最后更新时间")
    private Integer deleteFlag;

    @Column(name = "audit_data_version", columnDefinition = "int")
    @Comment("锁版本")
    private Integer auditDataVersion;

    @Column(name = "sec_bu_id", columnDefinition = "bigint")
    @Comment("数据归属组织id")
    private Long secBuId;

    @Column(name = "sec_user_id", columnDefinition = "bigint")
    @Comment("数据归属雇员id")
    private Long secUserId;

    @Column(name = "sec_ou_id", columnDefinition = "bigint")
    @Comment("数据归属公司id")
    private Long secOuId;

    @Column(name = "belong_org_id", columnDefinition = "bigint")
    @Comment("所属组织ID")
    private Long belongOrgId;

    @Column(name = "tenant_org_id", columnDefinition = "bigint")
    @Comment("租户组织ID")
    private Long tenantOrgId;

}