package com.elitesland.scp.mq;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.fin.param.recorder.WeChatPayRecOrderRpcParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderPayMqParam;
import com.elitesland.scp.rmi.RmiFinRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpOrderPayListener implements MessageQueueListener<ScpOrderPayMqParam> {

    private final RmiFinRpcService rmiFinRpcService;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{ScpOrderPayMqParam.SCP_ORDER_PAY_CHANNEL};
    }

    @Override
    public void onConsume(@NotBlank String s, @NotNull ScpOrderPayMqParam receiveSubmitMqParam) {
        log.info("调用财务中心，扣款操作，参数:{}", JSONUtil.toJsonStr(receiveSubmitMqParam));
        //调用财务中心，扣款操作
        WeChatPayRecOrderRpcParam payParam = new WeChatPayRecOrderRpcParam();
        payParam.setSourceNo(receiveSubmitMqParam.getSrcDocNo());
        payParam.setFlowNo(receiveSubmitMqParam.getFlowNo());
        payParam.setRealRecAmt(receiveSubmitMqParam.getRealRecAmt());
        payParam.setPayDateTime(receiveSubmitMqParam.getPayDateTime());
        rmiFinRpcService.wqfPay(payParam);
    }
}
