package com.elitesland.scp.application.facade.vo.param.app;

import com.elitesland.scp.domain.vo.survey.SurveyCheckRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 09月 16日 16:03
 * @version: 1.0
 */
@Data
@ApiModel(value = "小程序登陆账号协议状态查询")
public class AppLoginAccountStoreProtocolRespVO implements Serializable {

    @ApiModelProperty(value = "登陆账号")
    private String loginAccount;

    @ApiModelProperty(value = "登陆人名")
    private String loginName;

    @ApiModelProperty(value = "计划员工号")
    private String scpmanNo;

    @ApiModelProperty(value = "登陆人手机号")
    private String mobile;

    @ApiModelProperty("同意协议人名")
    private String protocolAgreeUserName;

    @ApiModelProperty("同意协议人手机号(法人)")
    private String protocolAgreeUserPhone;

    @ApiModelProperty(value = "同意协议状态")
    private Boolean protocolAgreeStatus;

    @ApiModelProperty(value = "强制校验协议标志")
    private Boolean forceCheck;

    @ApiModelProperty(value = "登陆账号类型")
    private String accountType;

    @ApiModelProperty(value = "是否成功")
    private Boolean success;

    @ApiModelProperty(value = "失败提示信息")
    private String msg;

    private String storeCode;

    private Long storeId;

    @ApiModelProperty(value = "问卷信息")
    private SurveyCheckRespVO survey;



}
