package com.elitesland.scp.application.facade.vo.template;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Auther: Mark
 * @Date: 2024/4/29 09:34
 * @Description:
 */
@Data
@ApiModel(description = "载入模板")
public class DemandOrderLoadParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("订货模板编号")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称")
    private String demandTemName;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不允许为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "类型，0:门店，1:仓库", required = true)
    @NotBlank(message = "订货单类型不允许为空")
    private String type;

    @ApiModelProperty(value = "单据类型", required = true)
    @NotBlank(message = "单据类型不允许为空")
    private String docType;
}
