package com.elitesland.scp.application.service.authority;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.*;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityDRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityRespVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanRegionVO;

import java.util.List;
import java.util.Optional;

public interface ScpsmanAuthorityService {

    /**
     * 计划员权限分页
     * @param paramVO
     * @return
     */
    PagingVO<ScpManAuthorityPageRespVO> queryAuthorit(ScpManAuthorityParam paramVO);

    /**
     * 状态修改
     *
     * @param paramVO
     */
    void changeStatus(ScpManAuthorityStatusParamVO paramVO);

    /**
     * 计划员权限 - 按区域添加门店/仓库
     *
     * @param paramVO
     */
    void region(ScpManAuthorityRegionParamVO paramVO);

    /**
     * 计划员权限 - 添加门店/仓库
     *
     * @param paramVO
     */
    void saveWhStore(ScpManAuthorityWhStoreParamVO paramVO);

    /**
     * 物理删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    void deleteByDIds(List<Long> ids);

    Optional<ScpsmanAuthorityRespVO> findIdOne(Long id);

    Long saveScpAuthority(ScpManAuthoritySaveVO saveVO);

    List<ScpManAuthorityPageRespVO> findByScpsmanNoIn(List<String> scpsmanNoList);

//    void executeImport(List<ScpManAuthorityImportVO> purPriceImportEntities);

    ApiResult<Boolean> createdByEmployee(String employeeCode);

    /**
     * 分页查询分配的权限信息
     *
     * @param queryParam
     * @return
     */
    ApiResult<PagingVO<ScpsmanAuthorityDRespVO>> pageQuery(ScpsmanAuthorityDPageQueryParam queryParam);
}
