package com.elitesland.scp.application.service.serviceconfig;

import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigImportVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * @author chaofeng.xia
 * @since 2025/5/26
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ScpServiceConfigImportServiceImpl implements DataImport<ScpServiceConfigImportVO> {

    private final ScpServiceConfigService scpServiceConfigService;


    @Override
    public String getTmplCode() {
        return "scp_service_config_import";
    }

    @Override
    public List<String> executeImport(List<ScpServiceConfigImportVO> dataList, int startRowIndex) {
        return scpServiceConfigService.executeImport(dataList, startRowIndex);
    }

    @Override
    public Integer stepSize() {
        return 1000;
    }

    @Override
    public Set<Integer> sheetNoList() {
        return Set.of(1);
    }
}
