package com.elitesland.scp.application.service.template;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.cart.CartAddItemParamVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.template.*;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.authority.StoreAuthorityService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.app.ScpStoreItemConvert;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrder;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrderDO;
import com.elitesland.scp.domain.entity.template.ScpTemplateSetDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.enums.DayOfWeekEnumHelper;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepo;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepo;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepoProc;
import com.elitesland.scp.rmi.*;
import com.elitesland.scp.service.authority.StoreAuthorityRpcService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 17:04
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class DemandOrderTemplateServiceImpl implements DemandOrderTemplateService {

    private final ScpDemandOrderTemplateRepo scpDemandOrderTemplateRepo;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;
    private final ScpDemandTemplateSetRepo scpDemandTemplateSetRepo;
    private final ScpDemandTemplateSetRepoProc scpDemandTemplateSetRepoProc;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final RmiSysUDCService rmiSysUDCService;

    private final StoreAuthorityRpcService storeAuthorityRpcService;
    private final RmiItemService rmiItemService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final RmiSalRpcService rmiSalRpcService;
    private final ScpCateItemDomainService scpCateItemDomainService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final StoreAuthorityService storeAuthorityService;
    private final CartRedisUtil cartRedisUtil;
    private final ScpStoreCartService scpStoreCartService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;


    @Override
    @SysCodeProc
    public DemandOrderDetailRespVO detail(DemandOrderDetailQueryVO vo) {
        DemandOrderDetailRespVO respVO = new DemandOrderDetailRespVO();
        respVO.setId(vo.getId());
        //主表数据
        Optional<ScpTemplateSetDO> templateSetRepoById = scpDemandTemplateSetRepo.findById(vo.getId());
        if (templateSetRepoById.isEmpty()) {
            return null;
        }
        ScpTemplateSetDO templateSetDO = templateSetRepoById.get();
        respVO.setRemark(templateSetDO.getRemark());
        respVO.setDemandTemCode(templateSetDO.getDemandTemCode());
        respVO.setDemandTemName(templateSetDO.getDemandTemName());
        respVO.setDetailedTime(templateSetDO.getDetailedTime());
        respVO.setStartDate(templateSetDO.getStartDate());
        respVO.setEndDate(templateSetDO.getEndDate());
        respVO.setDemandTemStatus(templateSetDO.getDemandTemStatus());
        respVO.setDocType(templateSetDO.getDocType());
        respVO.setBusinessType(templateSetDO.getBusinessType());
        respVO.setType(templateSetDO.getType());
        //明细行数据 包括门店 商品信息
        List<ScpTemplateOrderDO> orderData = scpDemandOrderTemplateRepoProc.findByMasId(vo.getId());
        if (CollUtil.isEmpty(orderData)) {
            return respVO;
        }

        //商品分类信息
        List<String> settings = scpOrderSettingDomainService.findItemCatesByBusinessType(templateSetDO.getBusinessType(), templateSetDO.getType());
        if (CollUtil.isNotEmpty(settings)) {
            respVO.setItemCates(settings);
        }

        List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode = removeDuplicatesByWhStZoCode(orderData);
        List<DemandOrderDetailRespVO.WhStZoObject> whStZoObjects = removeDuplicatesByWhStZoCode.stream().map(
                order -> {
                    DemandOrderDetailRespVO.WhStZoObject whStZoObject = new DemandOrderDetailRespVO.WhStZoObject();
                    if (order.getType() != null) {
                        whStZoObject.setType(order.getType().toString());
                    }
                    if (order.getType() != null) {
                        whStZoObject.setTypeName(getTypeName(whStZoObject.getType()));
                    }
                    whStZoObject.setWhStZoId(order.getWhStZoId());
                    whStZoObject.setWhStZoCode(order.getWhStZoCode());
                    whStZoObject.setWhStZoName(order.getWhStZoName());
                    whStZoObject.setDetailedAddress(order.getDetailedAddress());
                    whStZoObject.setBelongOrgCode(order.getBelongOrgCode());
                    whStZoObject.setBelongOrgName(order.getBelongOrgName());
                    whStZoObject.setBelongOuCode(order.getBelongOuCode());
                    whStZoObject.setBelongOuName(order.getBelongOuName());
                    whStZoObject.setStoreType(order.getStoreType());
                    if (StrUtil.isNotBlank(order.getStoreType())) {
                        whStZoObject.setStoreTypeName(getStoreTypeName(order.getStoreType()));
                    }
                    return whStZoObject;
                }
        ).collect(Collectors.toList());
        respVO.setWhStZoObjects(whStZoObjects);

        List<ScpTemplateOrderDO> removeDuplicatesByItemCode = removeDuplicatesByItemCode(orderData);
        List<DemandOrderDetailRespVO.ItemObject> itemObjects = removeDuplicatesByItemCode.stream().map(order -> {
            DemandOrderDetailRespVO.ItemObject itemObject = new DemandOrderDetailRespVO.ItemObject();
            itemObject.setItemId(order.getItemId());
            itemObject.setItemCode(order.getItemCode());
            itemObject.setItemName(order.getItemName());
            itemObject.setItemCateCode(order.getItemCateCode());  // 注意这里使用的是getItemCateCode()方法
            itemObject.setItemCateName(order.getItemCateName());
            itemObject.setItemSpec(order.getItemSpec());
            itemObject.setBasicUnitMeasure(order.getBasicUnitMeasure());
            itemObject.setBasicUnitMeasureName(order.getBasicUnitMeasureName());
            itemObject.setWeight(SysUtils.processQtyScale(order.getWeight()));
            itemObject.setDemandQuantity(SysUtils.processQtyScale(order.getDemandQuantity()));
            itemObject.setTotalWeight(SysUtils.processQtyScale(order.getTotalWeight()));  //
            itemObject.setWeightUom(order.getWeightUom());
            itemObject.setWeightUomName(order.getWeightUomName());
            itemObject.setUom2(order.getUom2());
            itemObject.setUom2Name(order.getUom2Name());
            itemObject.setQty2(order.getQty2());
            itemObject.setUomRatio(order.getUomRatio());
            itemObject.setDecimalPlaces(order.getDecimalPlaces());
            return itemObject;
        }).collect(Collectors.toList());

        respVO.setItemObjects(itemObjects);
        return respVO;
    }


    private String getRegionName(String regionCode) {
        Map<String, String> regionMap = rmiSysUDCService.getCodeMap("yst-supp", "REGION");
        return regionMap.get(regionCode);
    }

    private String getTypeName(String type) {
        Map<String, String> templateOrderType = rmiSysUDCService.getCodeMap("yst-suplan", "TEMPLATE_ORDER_TYPE");
        return templateOrderType.get(type);
    }

    private String getDocTypeName(String docType) {
        Map<String, String> templateOrderType = rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
        return templateOrderType.get(docType);
    }

    private String getStoreTypeName(String storeType) {
        Map<String, String> storeType2 = rmiSysUDCService.getCodeMap("yst-supp", "STORE_TYPE2");
        return storeType2.get(storeType);
    }


    public List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode(List<ScpTemplateOrderDO> orderData) {
        // 使用Java 8的Stream API和Collectors工具类来去重

        return orderData.stream().filter(e -> StrUtil.isNotBlank(e.getWhStZoCode()))
                .collect(Collectors.collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(ScpTemplateOrderDO::getWhStZoCode))),
                        ArrayList::new
                ));
    }

    public List<ScpTemplateOrderDO> removeDuplicatesByItemCode(List<ScpTemplateOrderDO> orderData) {
        // 使用Java 8的Stream API和Collectors工具类来去重

        return orderData.stream().filter(e -> StrUtil.isNotBlank(e.getItemCode()))
                .collect(Collectors.collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(ScpTemplateOrderDO::getItemCode))),
                        ArrayList::new
                ));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(DemandOrderSaveParamVO vo) {
        //新建需要先生成编码
        if (vo.getId() == null) {
            String demandTemCode = rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.BKTE, new ArrayList<>());
            vo.setDemandTemCode(demandTemCode);
        }

        // 创建ScpTemplateSetDO对象
        ScpTemplateSetDO scpTemplateSetDO = new ScpTemplateSetDO();
        scpTemplateSetDO.setId(vo.getId());
        scpTemplateSetDO.setDemandTemCode(vo.getDemandTemCode());
        scpTemplateSetDO.setDemandTemName(vo.getDemandTemName());
        scpTemplateSetDO.setStartDate(vo.getStartDate());
        scpTemplateSetDO.setEndDate(vo.getEndDate());
        scpTemplateSetDO.setDetailedTime(vo.getDetailedTime());
        scpTemplateSetDO.setDemandTemStatus(vo.getDemandTemStatus());
        scpTemplateSetDO.setRemark(vo.getRemark());
        scpTemplateSetDO.setDocType(vo.getDocType());
        scpTemplateSetDO.setType(vo.getType());
        // 设置其他属性...

        // 保存ScpTemplateSetDO对象
        scpTemplateSetDO = scpDemandTemplateSetRepo.save(scpTemplateSetDO);

        //如果是编辑，先删除既有明细
        if (vo.getId() != null) {
            log.info("编辑操作,先删除既有明细,masId:{}", vo.getId());
            scpDemandOrderTemplateRepoProc.deleteByMasId(vo.getId());
        }
        List<ScpTemplateOrderDO> entities = new ArrayList<>();
        Set<String> used = new HashSet<>();
        // 创建ScpTemplateOrderDO对象
        if (CollUtil.isNotEmpty(vo.getWhStZoObjects())) {
            for (DemandOrderSaveParamVO.WhStZoObject whStZoObject : vo.getWhStZoObjects()) {
                //重复编码只处理一次
                if (used.contains(whStZoObject.getWhStZoCode())) {
                    continue;
                }
                ScpTemplateOrderDO scpTemplateOrderDO = new ScpTemplateOrderDO();
                scpTemplateOrderDO.setMasId(scpTemplateSetDO.getId());
                scpTemplateOrderDO.setType(whStZoObject.getType());
                scpTemplateOrderDO.setWhStZoId(whStZoObject.getWhStZoId());
                scpTemplateOrderDO.setWhStZoCode(whStZoObject.getWhStZoCode());
                scpTemplateOrderDO.setWhStZoName(whStZoObject.getWhStZoName());
                scpTemplateOrderDO.setDetailedAddress(whStZoObject.getDetailedAddress());
                scpTemplateOrderDO.setBelongOrgCode(whStZoObject.getBelongOrgCode());
                scpTemplateOrderDO.setBelongOrgName(whStZoObject.getBelongOrgName());
                scpTemplateOrderDO.setBelongOuCode(whStZoObject.getBelongOuCode());
                scpTemplateOrderDO.setBelongOuName(whStZoObject.getBelongOuName());
                scpTemplateOrderDO.setStoreType(whStZoObject.getStoreType());
                entities.add(scpTemplateOrderDO);
                used.add(whStZoObject.getWhStZoCode());
            }
        }
        Map<String, BigDecimal> itemMap = new HashMap<>();
        if (CollUtil.isNotEmpty(vo.getItemObjects())) {
            Map<String, List<DemandOrderSaveParamVO.ItemObject>> itemCodeMap =
                    vo.getItemObjects().stream().collect(Collectors.groupingBy(DemandOrderSaveParamVO.ItemObject::getItemCode));
            for (Map.Entry<String, List<DemandOrderSaveParamVO.ItemObject>> entry : itemCodeMap.entrySet()) {
                BigDecimal qtySum =
                        entry.getValue().stream().map(DemandOrderSaveParamVO.ItemObject::getDemandQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                qtySum = SysUtils.processQtyScale(qtySum);

                DemandOrderSaveParamVO.ItemObject itemObject = entry.getValue().get(0);
                String itemCode = itemObject.getItemCode();
                if (StrUtil.isBlank(itemObject.getItemCateCode())) {
                    throw new BusinessException(itemCode + "对应的商品品类编码为空");
                }

                ScpTemplateOrderDO scpTemplateOrderDO = new ScpTemplateOrderDO();
                scpTemplateOrderDO.setMasId(scpTemplateSetDO.getId());
                scpTemplateOrderDO.setItemId(itemObject.getItemId());
                scpTemplateOrderDO.setItemCode(itemCode);
                scpTemplateOrderDO.setItemName(itemObject.getItemName());
                scpTemplateOrderDO.setItemCateCode(itemObject.getItemCateCode());
                scpTemplateOrderDO.setItemCateName(itemObject.getItemCateName());
                scpTemplateOrderDO.setItemSpec(itemObject.getItemSpec());
                scpTemplateOrderDO.setBasicUnitMeasure(itemObject.getBasicUnitMeasure());
                scpTemplateOrderDO.setBasicUnitMeasureName(itemObject.getBasicUnitMeasureName());
                scpTemplateOrderDO.setWeight(SysUtils.processQtyScale(itemObject.getWeight()));
                scpTemplateOrderDO.setDemandQuantity(qtySum);
                scpTemplateOrderDO.setTotalWeight(SysUtils.processQtyScale(itemObject.getTotalWeight()));
                scpTemplateOrderDO.setWeightUom(itemObject.getWeightUom());
                scpTemplateOrderDO.setWeightUomName(itemObject.getWeightUomName());
                scpTemplateOrderDO.setUom2(itemObject.getUom2());
                scpTemplateOrderDO.setUom2Name(itemObject.getUom2Name());
                scpTemplateOrderDO.setUomRatio(itemObject.getUomRatio());
                scpTemplateOrderDO.setQty2(itemObject.getQty2());
                scpTemplateOrderDO.setDecimalPlaces(itemObject.getDecimalPlaces());
                entities.add(scpTemplateOrderDO);
            }

        }
        // 保存ScpTemplateOrderDO对象
        if (CollUtil.isNotEmpty(entities)) {
            scpDemandOrderTemplateRepo.saveAll(entities);
        }
        // 返回ScpTemplateSetDO对象的id
        return scpTemplateSetDO.getId();
    }

    @Override
    @SysCodeProc
    public PagingVO<DemandOrderPageRespVO> page(DemandOrderPageQueryVO vo) {
        if (Boolean.TRUE.equals(vo.getScpmanAuthority())) {
            //计划员数据权限
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO<>();
            }
            extractedAuthorityParam(vo, pagingVO);
            List<ScpTemplateOrder> scpTemplateOrders = scpDemandOrderTemplateRepoProc.findMasIdsByWhStZoIds(vo.getStoreIds(), vo.getWhIds());
            if (CollectionUtil.isEmpty(scpTemplateOrders)) {
                return new PagingVO<>();
            }
            vo.setIds(scpTemplateOrders.stream().map(ScpTemplateOrder::getMasId)
                    .filter(Objects::nonNull)
                    .distinct().collect(Collectors.toList()));
        }
        PagingVO<DemandOrderPageRespVO> data = scpDemandTemplateSetRepoProc.findTemplateSet(vo);
        List<DemandOrderPageRespVO> records = data.getRecords();
        List<Long> templateIds =
                records.stream().map(DemandOrderPageRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        Map<Long, BigDecimal> itemTypeMap = sumItemCodes(orderList);
        records.forEach(item -> {
            item.setTypeNumber(itemTypeMap.get(item.getId()));
        });
        return data;
    }

    public Map<Long, BigDecimal> sumItemCodes(List<ScpTemplateOrderDO> orderData) {
        List<ScpTemplateOrderDO> filteredList =
                orderData.stream().filter(e -> StrUtil.isNotBlank(e.getItemCode())).collect(Collectors.toList());
        Map<Long, Set<String>> itemCodesMap = new HashMap<>();
        Map<Long, BigDecimal> sumItemCodesMap = new HashMap<>();

        for (ScpTemplateOrderDO order : filteredList) {
            Long masId = order.getMasId();
            String itemCode = order.getItemCode();

            // 如果itemCodesMap中不包含masId，或者itemCodesMap中包含masId但不包含itemCode，我们就需要计算itemCode
            if (!itemCodesMap.containsKey(masId) || !itemCodesMap.get(masId).contains(itemCode)) {
                BigDecimal sum = sumItemCodesMap.getOrDefault(masId, BigDecimal.ZERO);
                sum = sum.add(BigDecimal.ONE);
                sumItemCodesMap.put(masId, sum);

                // 更新itemCodesMap
                Set<String> itemCodes = itemCodesMap.getOrDefault(masId, new HashSet<>());
                itemCodes.add(itemCode);
                itemCodesMap.put(masId, itemCodes);
            }
        }

        return sumItemCodesMap;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void statusChange(DemandOrderStatusChangeParamVO vo) {
        scpDemandTemplateSetRepoProc.updateStatus(vo.getDemandTemStatus(), vo.getIds());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(DemandOrderDeleteParamVO vo) {
        scpDemandTemplateSetRepoProc.delete(vo.getIds());
    }

    @Override
    public PagingVO<DemandOrderPageRespVO> load(DemandOrderLoadParamVO vo) {
        log.info("加载模板入参:{}", JSONUtil.toJsonStr(vo));
        List<DemandOrderPageRespVO> templateSetLoad = scpDemandTemplateSetRepoProc.findTemplateSetLoad(vo);
        log.info("加载模板查询结果,过滤前:{}", JSONUtil.toJsonStr(templateSetLoad));
        templateSetLoad =
                templateSetLoad.stream().filter(e -> detailedTimeContainsDay(e.getDetailedTime())).collect(Collectors.toList());
        log.info("加载模板查询结果,过滤详细日期后:{}", JSONUtil.toJsonStr(templateSetLoad));
        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        String region = "";
        if (isStore) {
            OrgStoreDetailRpcDTO storeDetailRpcDTO = rmiOrgStoreRpcService.findOrgStoreByStoreCode(demandWhStCode);
            if (storeDetailRpcDTO != null) {
                region = storeDetailRpcDTO.getRegion();
            }
        }
        List<Long> templateIds =
                templateSetLoad.stream().map(DemandOrderPageRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        List<Long> tempIdsByType =
                orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(demandWhStCode)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        List<Long> tempIdsByRegion = new ArrayList<>();
        if (StrUtil.isNotBlank(region) && isStore) {
            String finalRegion = region;
            tempIdsByRegion =
                    orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(finalRegion)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        }
        List<Long> expected = new ArrayList<>();
        expected.addAll(tempIdsByType);
        expected.addAll(tempIdsByRegion);
        expected = expected.stream().distinct().collect(Collectors.toList());
        List<Long> finalExpected = expected;
        List<DemandOrderPageRespVO> filterData =
                templateSetLoad.stream().filter(e -> finalExpected.contains(e.getId())).collect(Collectors.toList());
        log.info("加载模板查询结果,过滤后:{}", JSONUtil.toJsonStr(filterData));

        List<DemandOrderPageRespVO> records = toPage(vo.getCurrent(), vo.getSize(),
                filterData);
        return PagingVO.<DemandOrderPageRespVO>builder().total(filterData.size()).records(records).build();
    }

    private boolean detailedTimeContainsDay(String detailedTimeStr) {
        DayOfWeek dayOfWeek = LocalDate.now().getDayOfWeek();
        String dayOfWeekStr = dayOfWeek.toString();
        List<String> list = DayOfWeekEnumHelper.splitAndList(detailedTimeStr);
        return list.contains(dayOfWeekStr);
    }

    @Override
    public List<DemandOrderListRespVO> list(DemandOrderListParamVO vo) {
        log.info("选择模板列表入参:{}", JSONUtil.toJsonStr(vo));
        List<DemandOrderListRespVO> templateSetList = scpDemandTemplateSetRepoProc.findTemplateSetList(vo);
        log.info("选择模板列表结果,过滤前:{}", JSONUtil.toJsonStr(templateSetList));
        templateSetList =
                templateSetList.stream().filter(e -> detailedTimeContainsDay(e.getDetailedTime())).collect(Collectors.toList());
        log.info("选择模板列表结果,过滤详细日期后:{}", JSONUtil.toJsonStr(templateSetList));

        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        String region = "";
        if (isStore) {
            OrgStoreDetailRpcDTO storeDetailRpcDTO = rmiOrgStoreRpcService.findOrgStoreByStoreCode(demandWhStCode);
            if (storeDetailRpcDTO != null) {
                region = storeDetailRpcDTO.getRegion();
            }
        }
        List<Long> templateIds =
                templateSetList.stream().map(DemandOrderListRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        List<Long> tempIdsByType =
                orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(demandWhStCode)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        List<Long> tempIdsByRegion = new ArrayList<>();
        if (StrUtil.isNotBlank(region) && isStore) {
            String finalRegion = region;
            tempIdsByRegion =
                    orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(finalRegion)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        }
        List<Long> expected = new ArrayList<>();
        expected.addAll(tempIdsByType);
        expected.addAll(tempIdsByRegion);
        expected = expected.stream().distinct().collect(Collectors.toList());
        List<Long> finalExpected = expected;
        List<DemandOrderListRespVO> filterData =
                templateSetList.stream().filter(e -> finalExpected.contains(e.getId())).collect(Collectors.toList());
        log.info("加载模板查询结果,过滤后:{}", JSONUtil.toJsonStr(filterData));
        if (CollUtil.isEmpty(filterData)) {
            return filterData;
        }
        List<Long> templateIdsFiltered =
                filterData.stream().map(DemandOrderListRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderListFiltered = scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIdsFiltered);
        Map<Long, BigDecimal> itemTypeMap = sumItemCodes(orderListFiltered);
        filterData.forEach(
                item -> {
                    item.setTypeNumber(itemTypeMap.get(item.getId()));
                }
        );
        return filterData;
    }


    public static List<DemandOrderPageRespVO> toPage(int page, int size, List<DemandOrderPageRespVO> list) {
        int fromIndex = page * size;
        int toIndex = page * size + size;
        if (fromIndex > list.size()) {
            return new ArrayList<>();
        } else if (toIndex >= list.size()) {
            return list.subList(fromIndex, list.size());
        } else {
            return list.subList(fromIndex, toIndex);
        }
    }

    @Override
    public DemandOrderApplyRespVO apply(DemandOrderApplyParamVO vo) {
        log.info("应用模板入参:{}", JSONUtil.toJsonStr(vo));
        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        DemandOrderApplyRespVO result = new DemandOrderApplyRespVO();
        List<ScpTemplateOrderDO> orderTemList =
                scpDemandOrderTemplateRepoProc.findByMasIdIn(vo.getIds()).stream().filter(e -> StrUtil.isNotBlank(e.getItemCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(orderTemList)) {
            return buildDefaultResult();
        }
        log.info("模板应用,商品详情数据{}", JSONUtil.toJsonStr(orderTemList));

        Map<String, DemandOrderApplySuccessRespVO> successMap = new HashMap<>();
        List<DemandOrderApplyFailureRespVO> fail = new ArrayList<>();
        //获取门店权限内的商品
        List<String> itemCodePermittedList = new ArrayList<>();
        if (isStore) {
            List<StoreAuthorityRespDTO.ItemInfo> itemsByStoreCode = getPermitedItemsByStoreCode(demandWhStCode);
            itemCodePermittedList =
                    itemsByStoreCode.stream().map(StoreAuthorityRespDTO.ItemInfo::getItemCode).distinct().collect(Collectors.toList());
        }
        log.info("门店要货权限商品编码集合{}", JSONUtil.toJsonStr(itemCodePermittedList));

        List<String> itemCodeList =
                orderTemList.stream().map(ScpTemplateOrderDO::getItemCode).distinct().collect(Collectors.toList());

        List<String> existItemCodes = scpCateItemDomainService.existByItemCodes(itemCodeList);
        log.info("小程序上架的商品{}", JSONUtil.toJsonStr(existItemCodes));

        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(vo.getBusinessType(), type);
        var priceParamVOS = orderTemList.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
//            priceParamVO.setItemType2(row.getItemType2());
            priceParamVO.setUom(row.getUom2());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, AppItemPriceRespVO> priceMap = commonPriceService.getNewPriceAndStockDetails(priceParamVOS, demandWhStCode, orderSetting, type);

        for (ScpTemplateOrderDO templateOrderDO : orderTemList) {
            String itemCode = templateOrderDO.getItemCode();
            String itemName = templateOrderDO.getItemName();

            //校验是否是小程序商品
            if ("BOH".equals(vo.getInvoker())) {
                if (!existItemCodes.contains(itemCode)) {
                    addFail(fail, itemCode, itemName, "该商品不属于小程序商品");
                    continue;
                }
            }
            //校验商品价格
            if (!priceMap.containsKey(itemCode)) {
                addFail(fail, itemCode, itemName, "该商品没有结算价");
                continue;
            }

            if (!itemCodePermittedList.contains(itemCode) && isStore) {
                addFail(fail, itemCode, itemName, "门店要货权限不包含");
                continue;
            }
            //构造成功的商品数据
            addSuccess(successMap, templateOrderDO, null);
        }

        List<DemandOrderApplySuccessRespVO> success = new ArrayList<>(successMap.values());
        processItemInfo(success);
        result.setSuccess(success);
        result.setFail(fail);
        if (success.size() == 0) {
            result.setAllFailed(true);
        }
        log.info("应用模板结果:{}", JSONUtil.toJsonStr(result));
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DemandOrderApplyRespVO applyCart(DemandOrderApplyParamVO vo) {
        String demandWhStCode = vo.getDemandWhStCode();
        vo.setInvoker("BOH");
        TemplateApplyCartContext context = new TemplateApplyCartContext();
        DemandOrderApplyRespVO respVO = applyBOH(vo, context);
        //将过滤出的商品添加采购车
        List<DemandOrderApplySuccessRespVO> success = respVO.getSuccess();
        if (CollUtil.isEmpty(success)) {
            return respVO;
        }
        log.info("小程序模板过滤成功商品信息:{}", JSONUtil.toJsonStr(success));
        CartAddItemParamVO cartAddItemParamVO = formatToCartAdd(success, demandWhStCode, context.getPriceMap());
        log.info("小程序模板商品添加采购车信息:{}", JSONUtil.toJsonStr(cartAddItemParamVO));
        // 将原采购车所有商品置为未勾选
        Long currentUserId = UserService.currentUserId();
        cartRedisUtil.updateUnSelectedStoreCartItems(vo.getDemandWhStCode(), currentUserId, vo.getDocType());
        //添加模板商品到采购车
        List<StoreCartSaveVO> saveVOS = ScpStoreItemConvert.INSTANCE.paramVosToSaveVos(cartAddItemParamVO.getItemSpecObjectVOS());
        scpStoreCartService.batchSaveCart(demandWhStCode, vo.getDocType(), saveVOS);
        return respVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandTemplateExportRespVO> queryTemplateExport(ScpDemandTemplateExportParamVO vo) {
        List<ScpDemandTemplateExportRespVO> resultVoList = new ArrayList<>();

        //主表数据
        PagingVO<ScpDemandTemplateExportRespVO> data = scpDemandTemplateSetRepoProc.findTemplateSetExport(vo);
        List<ScpDemandTemplateExportRespVO> records = data.getRecords();
        Map<Long, ScpDemandTemplateExportRespVO> templateHeaderData =
                records.stream().collect(Collectors.toMap(ScpDemandTemplateExportRespVO::getId, Function.identity()));
        List<Long> templateIds =
                records.stream().map(ScpDemandTemplateExportRespVO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        Map<Long, List<ScpTemplateOrderDO>> groupedTemplateDetail =
                orderList.stream().collect(Collectors.groupingBy(ScpTemplateOrderDO::getMasId));
        Map<Long, BigDecimal> itemTypeMap = sumItemCodes(orderList);
        records.forEach(item -> item.setTypeNumber(itemTypeMap.get(item.getId())));
        for (Map.Entry<Long, List<ScpTemplateOrderDO>> entry : groupedTemplateDetail.entrySet()) {
            Long templateId = entry.getKey();
            ScpDemandTemplateExportRespVO templateHeader = templateHeaderData.get(templateId);
            List<ScpTemplateOrderDO> templateOrderDOS = entry.getValue();
            for (ScpTemplateOrderDO templateOrderDO : templateOrderDOS) {
                ScpDemandTemplateExportRespVO resultVo = new ScpDemandTemplateExportRespVO();

                //模板主表数据
                resultVo.setId(templateHeader.getId());
                resultVo.setDemandTemCode(templateHeader.getDemandTemCode());
                resultVo.setDemandTemName(templateHeader.getDemandTemName());
                resultVo.setDocType(templateHeader.getDocType());
                resultVo.setDocTypeName(getDocTypeName(templateHeader.getDocType()));
                resultVo.setDemandType(templateHeader.getDemandType());
                resultVo.setStartDate(templateHeader.getStartDate());
                resultVo.setEndDate(templateHeader.getEndDate());
                if (StrUtil.isNotBlank(templateHeader.getDetailedTime())) {
                    resultVo.setDetailedTime(DayOfWeekEnumHelper.splitAndListDesc(templateHeader.getDetailedTime()));
                }
                resultVo.setDemandTemStatus(templateHeader.getDemandTemStatus());
                resultVo.setDemandTemStatusName(getStatusName(templateHeader.getDemandTemStatus()));
                resultVo.setTypeNumber(templateHeader.getTypeNumber());
                resultVo.setCreator(templateHeader.getCreator());
                resultVo.setCreateTime(templateHeader.getCreateTime());
                resultVo.setRemark(templateHeader.getRemark());
                //门店/仓库/区域数据
                //商品数据
                if (templateOrderDO.getType() != null) {
                    resultVo.setType(templateOrderDO.getType().toString());
                }
                if (templateOrderDO.getType() != null) {
                    resultVo.setTypeName(getTypeName(resultVo.getType()));
                }
                resultVo.setWhStZoId(templateOrderDO.getWhStZoId());
                resultVo.setWhStZoCode(templateOrderDO.getWhStZoCode());
                resultVo.setWhStZoName(templateOrderDO.getWhStZoName());
                resultVo.setDetailedAddress(templateOrderDO.getDetailedAddress());
                resultVo.setBelongOrgCode(templateOrderDO.getBelongOrgCode());
                resultVo.setBelongOrgName(templateOrderDO.getBelongOrgName());
                resultVo.setBelongOuCode(templateOrderDO.getBelongOuCode());
                resultVo.setBelongOuName(templateOrderDO.getBelongOuName());
                resultVo.setStoreType(templateOrderDO.getStoreType());
                if (StrUtil.isNotBlank(templateOrderDO.getStoreType())) {
                    resultVo.setStoreTypeName(getStoreTypeName(templateOrderDO.getStoreType()));
                }
                resultVo.setItemId(templateOrderDO.getItemId());
                resultVo.setItemCode(templateOrderDO.getItemCode());
                resultVo.setItemName(templateOrderDO.getItemName());
                resultVo.setItemCateCode(templateOrderDO.getItemCateCode());
                resultVo.setItemCateName(templateOrderDO.getItemCateName());
                resultVo.setItemSpec(templateOrderDO.getItemSpec());
                resultVo.setBasicUnitMeasure(templateOrderDO.getBasicUnitMeasure());
                if (templateOrderDO.getWeight() != null) {
                    resultVo.setWeight(SysUtils.processQtyScale(templateOrderDO.getWeight()) + getUomName(templateOrderDO.getWeightUomName()));
                }

                resultVo.setWeightUom(templateOrderDO.getWeightUom());
                resultVo.setWeightUomName(templateOrderDO.getWeightUomName());
                resultVo.setDemandQuantity(templateOrderDO.getDemandQuantity());
                if (templateOrderDO.getTotalWeight() != null) {
                    resultVo.setTotalWeight(SysUtils.processQtyScale(templateOrderDO.getTotalWeight()) + getUomName(templateOrderDO.getWeightUomName()));
                }
                resultVoList.add(resultVo);
            }
        }
        int total = getPageTotal(vo);
        log.info("订货模板导出,total:{},resultVoList:{}", total, JSONUtil.toJsonStr(resultVoList));
        return PagingVO.<ScpDemandTemplateExportRespVO>builder().total(total).records(resultVoList).build();
    }

    private String getStatusName(Integer status) {
        if (1 == status) {
            return "启用";
        } else if (0 == status) {
            return "禁用";
        } else {
            return "N/A";
        }
    }

    private String getUomName(String uomName) {
        if (uomName == null) {
            return "";
        } else {
            return uomName;
        }
    }

    private int getPageTotal(ScpDemandTemplateExportParamVO vo) {
        List<Long> ids = vo.getIds();
        //导出全部数据
        if (CollUtil.isEmpty(ids)) {
            List<ScpTemplateOrderDO> orderList = scpDemandOrderTemplateRepoProc.findALL();
            return orderList.size();
        } else {
            List<ScpTemplateOrderDO> orderList = scpDemandOrderTemplateRepoProc.findByMasIdIn(ids);
            return orderList.size();
        }
    }

    private CartAddItemParamVO formatToCartAdd(List<DemandOrderApplySuccessRespVO> success, String demandWhStCode,
                                               Map<String, AppItemPriceRespVO> priceMap) {
        CartAddItemParamVO cartAddItemParamVO = new CartAddItemParamVO();
        //   Map<String, PriPriceRpcDTO> priceMap = getPriceMap(success, demandWhStCode);
        log.info("价格字典数据:{}", JSONUtil.toJsonStr(priceMap));
        //单规格
        List<Long> itemsOneSpec =
                success.stream().filter(e -> "1".equals(e.getItemAttr2())).map(DemandOrderApplySuccessRespVO::getSpuId).distinct().collect(Collectors.toList());
        log.info("单规格商品spuId:{}", JSONUtil.toJsonStr(itemsOneSpec));
        //多规格
        List<Long> itemsMulSpec =
                success.stream().filter(e -> "0".equals(e.getItemAttr2())).map(DemandOrderApplySuccessRespVO::getItemId).distinct().collect(Collectors.toList());
        log.info("多规格商品itemId:{}", JSONUtil.toJsonStr(itemsMulSpec));

        Map<Long, ItmItemAttachmentProviderDTO> skuImgByItemIdsOneSpec = new HashMap<>();
        Map<Long, ItmItemAttachmentProviderDTO> skuImgByItemIdsMulSpec = new HashMap<>();
        List<Long> itemIdTotal = new ArrayList<>();
        itemIdTotal.addAll(itemsOneSpec);
        itemIdTotal.addAll(itemsMulSpec);
        log.info("所有校验成功商品itemId:{}", JSONUtil.toJsonStr(itemIdTotal));
        List<ItmItemAttachmentProviderDTO> list = rmiItemService.findSkuImgByItemIds(itemIdTotal);

        if (CollUtil.isNotEmpty(list)) {
            skuImgByItemIdsOneSpec =
                    list.stream().filter(e -> itemsOneSpec.contains(e.getItemId())).collect(Collectors.toMap(ItmItemAttachmentProviderDTO::getItemId,
                            Function.identity(), (oldValue, newValue) -> oldValue));
            skuImgByItemIdsMulSpec =
                    list.stream().filter(e -> itemsMulSpec.contains(e.getItemId())).collect(Collectors.toMap(ItmItemAttachmentProviderDTO::getItemId,
                            Function.identity(), (oldValue, newValue) -> oldValue));
        }

        log.info("单规格商品Map:{},多规格商品Map:{}", JSONUtil.toJsonStr(skuImgByItemIdsOneSpec),
                JSONUtil.toJsonStr(skuImgByItemIdsMulSpec));
        cartAddItemParamVO.setDemandWhStCode(demandWhStCode);
        Map<Long, ItmItemAttachmentProviderDTO> finalSkuImgByItemIdsOneSpec = skuImgByItemIdsOneSpec;
        Map<Long, ItmItemAttachmentProviderDTO> finalSkuImgByItemIdsMulSpec = skuImgByItemIdsMulSpec;
        List<CartAddItemParamVO.ItemSpecObjectVO> itemSpecObjectVOS = success.stream().map(
                item -> {
                    String key = item.getItemCode() + "-" + item.getUom();
                    CartAddItemParamVO.ItemSpecObjectVO vo = new CartAddItemParamVO.ItemSpecObjectVO();
                    vo.setItemId(item.getItemId());
                    vo.setItemCode(item.getItemCode());
                    vo.setItemName(item.getItemName());
                    vo.setUom(item.getUom());
                    vo.setUomName(item.getUomName());
                    vo.setSpuCode(item.getSpuItemCode());
                    vo.setSpuName(item.getSpuItemName());
                    vo.setQty(item.getDemandQuantity());
                    if (priceMap.containsKey(key)) {
                        AppItemPriceRespVO priceRespVO = priceMap.get(item.getItemCode());
                        vo.setItemPrice(priceRespVO.getPrice());
                        vo.setSuppId(priceRespVO.getSuppId());
                        vo.setSuppCode(priceRespVO.getSuppCode());
                        vo.setStoreCode(priceRespVO.getStoreCode());
                        vo.setCostPrice(priceRespVO.getCostPrice());
                        vo.setPurPrice(priceRespVO.getPurPrice());
                        vo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                        vo.setTefPrice(priceRespVO.getTefPrice());
                        vo.setMefPrice(priceRespVO.getMefPrice());
                        vo.setOefPrice(priceRespVO.getOefPrice());
                        vo.setSalePrice(priceRespVO.getSalePrice());
                    }

                    vo.setSpec(item.getSpec());
                    vo.setUrl(getItemUrl(item.getItemAttr2(), item.getItemId(), item.getSpuId(),
                            finalSkuImgByItemIdsOneSpec,
                            finalSkuImgByItemIdsMulSpec));
                    vo.setItemCateCode(item.getItemCateCode());
                    vo.setItemCateName(item.getItemCateName());
                    vo.setItemPrice(item.getItemPrice());
                    return vo;
                }
        ).collect(Collectors.toList());
        cartAddItemParamVO.setItemSpecObjectVOS(itemSpecObjectVOS);
        log.info("小程序模板商品添加采购车信息:{}", JSONUtil.toJsonStr(cartAddItemParamVO));
        return cartAddItemParamVO;
    }

    //根据商品规格获取图片的url
    private String getItemUrl(String itemAttr2, Long itemId, Long spuId,
                              Map<Long, ItmItemAttachmentProviderDTO> skuImgByItemIdsOneSpec,
                              Map<Long, ItmItemAttachmentProviderDTO> skuImgByItemIdsMulSpec) {
        if ("1".equals(itemAttr2) && skuImgByItemIdsOneSpec.containsKey(spuId)) {
            return skuImgByItemIdsOneSpec.get(spuId).getUrl();
        }
        if ("0".equals(itemAttr2) && skuImgByItemIdsMulSpec.containsKey(itemId)) {
            return skuImgByItemIdsMulSpec.get(itemId).getUrl();
        }
        return "";
    }

    private void addSuccess(Map<String, DemandOrderApplySuccessRespVO> successMap, ScpTemplateOrderDO templateOrderDO,
                            AppItemPriceRespVO priceRespVO) {
        String itemCode = templateOrderDO.getItemCode();
        if (successMap.containsKey(itemCode)) {
            DemandOrderApplySuccessRespVO vo = successMap.get(itemCode);
            BigDecimal oldQty = vo.getDemandQuantity();
            BigDecimal newQty = templateOrderDO.getQty2();
            BigDecimal sumQty = oldQty.add(newQty);
            vo.setDemandQuantity(sumQty);
        } else {
            DemandOrderApplySuccessRespVO vo = new DemandOrderApplySuccessRespVO();
            vo.setItemId(templateOrderDO.getItemId());
            vo.setItemCode(templateOrderDO.getItemCode());
            vo.setItemName(templateOrderDO.getItemName());
            vo.setDemandQuantity(templateOrderDO.getQty2());
            vo.setItemCateCode(templateOrderDO.getItemCateCode());
            vo.setItemCateName(templateOrderDO.getItemCateName());
            vo.setQty2(templateOrderDO.getDemandQuantity());
            vo.setUom2(templateOrderDO.getBasicUnitMeasure());
            vo.setUom2Name(templateOrderDO.getBasicUnitMeasureName());
            vo.setDecimalPlaces(templateOrderDO.getDecimalPlaces());
            vo.setUomRatio(templateOrderDO.getUomRatio());
            if (priceRespVO != null) {
                vo.setItemPrice(priceRespVO.getPrice());
                vo.setSuppId(priceRespVO.getSuppId());
                vo.setSuppCode(priceRespVO.getSuppCode());
                vo.setStoreCode(priceRespVO.getStoreCode());
                vo.setCostPrice(priceRespVO.getCostPrice());
                vo.setPurPrice(priceRespVO.getPurPrice());
                vo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                vo.setTefPrice(priceRespVO.getTefPrice());
                vo.setMefPrice(priceRespVO.getMefPrice());
                vo.setOefPrice(priceRespVO.getOefPrice());


            }
            successMap.put(itemCode, vo);
        }
    }

    private void addFail(List<DemandOrderApplyFailureRespVO> fail, String itemCode, String itemName, String msg) {
        DemandOrderApplyFailureRespVO failVO = new DemandOrderApplyFailureRespVO();
        failVO.setItemCode(itemCode);
        failVO.setItemName(itemName);
        failVO.setMsg(msg);
        fail.add(failVO);
    }

    private DemandOrderApplyRespVO buildDefaultResult() {
        DemandOrderApplyRespVO vo = new DemandOrderApplyRespVO();
        vo.setAllFailed(false);
        vo.setFail(new ArrayList<>());
        vo.setSuccess(new ArrayList<>());
        return vo;
    }

    //获取门店权限内的商品
    private List<StoreAuthorityRespDTO.ItemInfo> getPermitedItemsByStoreCode(String storeCode) {
        StoreAuthorityRpcDTO storeAuthorityRpcDTO = new StoreAuthorityRpcDTO();
        storeAuthorityRpcDTO.setStoreCode(storeCode);
        StoreAuthorityRespDTO data = storeAuthorityRpcService.getStoreAuthorityData(storeAuthorityRpcDTO).getData();
        if (data == null) {
            return new ArrayList<>();
        } else {
            return data.getItemInfos();
        }
    }

    private PagingVO<ScpManAuthorityPageRespVO> getAuthorityPageRespVOPagingVO() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(1, 0));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }

    private void extractedAuthorityParam(DemandOrderPageQueryVO queryParam, PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        List<ScpManAuthorityPageRespVO> records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<Long> whIds = records.stream()
                .filter(v -> 1 == v.getType())
                .map(ScpManAuthorityPageRespVO::getStWhId)
                .filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> storeIds = records.stream()
                .filter(v -> 0 == v.getType())
                .map(ScpManAuthorityPageRespVO::getStWhId)
                .filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhIds(whIds);
        queryParam.setStoreIds(storeIds);
    }

    public DemandOrderApplyRespVO applyBOH(DemandOrderApplyParamVO vo, TemplateApplyCartContext context) {
        log.info("应用模板入参:{}", JSONUtil.toJsonStr(vo));
        String demandWhStCode = vo.getDemandWhStCode();
        String type = vo.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        DemandOrderApplyRespVO result = new DemandOrderApplyRespVO();
        List<ScpTemplateOrderDO> orderTemList =
                scpDemandOrderTemplateRepoProc.findByMasIdIn(vo.getIds()).stream().filter(e -> StrUtil.isNotBlank(e.getItemCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(orderTemList)) {
            return buildDefaultResult();
        }
        log.info("模板应用,商品详情数据{}", JSONUtil.toJsonStr(orderTemList));
        List<String> itemCodeList =
                orderTemList.stream().map(ScpTemplateOrderDO::getItemCode).distinct().collect(Collectors.toList());

        Map<String, DemandOrderApplySuccessRespVO> successMap = new HashMap<>();
        List<DemandOrderApplyFailureRespVO> fail = new ArrayList<>();
        //获取门店权限内的商品
        List<String> itemCodePermittedList = new ArrayList<>();
        if (isStore) {
            List<StoreAuthorityRespDTO.ItemInfo> itemsByStoreCode = getPermitedItemsByStoreCodeBOH(demandWhStCode, vo.getDocType(), type,
                    context, itemCodeList);
            itemCodePermittedList =
                    itemsByStoreCode.stream().map(StoreAuthorityRespDTO.ItemInfo::getItemCode).distinct().collect(Collectors.toList());
        }
        log.info("门店要货权限商品编码集合{}", JSONUtil.toJsonStr(itemCodePermittedList));

        List<String> allBOHItemCodes = scpCateItemDomainService.existByItemCodes(itemCodeList);
        log.info("小程序上架商品{}", JSONUtil.toJsonStr(allBOHItemCodes));

        //  查询商品
        ItmItemBaseRpcParam rpcParam = new ItmItemBaseRpcParam();
        rpcParam.setItemCodes(allBOHItemCodes);
        List<ItmItemBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemBaseRpcDtoByParam(rpcParam);
        context.setItemRpcDtoByParam(itemRpcDtoByParam);

        Map<String, AppItemPriceRespVO> priceMap = context.getPriceMap();

        for (ScpTemplateOrderDO templateOrderDO : orderTemList) {
            String itemCode = templateOrderDO.getItemCode();
            String itemName = templateOrderDO.getItemName();

            //校验是否是小程序商品
            if ("BOH".equals(vo.getInvoker())) {
                if (!allBOHItemCodes.contains(itemCode)) {
                    addFail(fail, itemCode, itemName, "该商品不属于小程序商品");
                    continue;
                }
            }

            if (!itemCodePermittedList.contains(itemCode) && isStore) {
                addFail(fail, itemCode, itemName, "门店要货权限不包含");
                continue;
            }

            if (!priceMap.containsKey(itemCode)) {
                addFail(fail, itemCode, itemName, "该商品没有查询到价格");
                continue;
            }
            AppItemPriceRespVO priceRespVO = priceMap.get(itemCode);

            //构造成功的商品数据
            addSuccess(successMap, templateOrderDO, priceRespVO);
        }
        List<DemandOrderApplySuccessRespVO> success = new ArrayList<>(successMap.values());
        processItemInfoBOH(success, context);
        result.setSuccess(success);
        result.setFail(fail);
        if (success.size() == 0) {
            result.setAllFailed(true);
        }
        log.info("应用模板结果:{}", JSONUtil.toJsonStr(result));
        return result;
    }

    //填充商品详情数据
    private void processItemInfoBOH(List<DemandOrderApplySuccessRespVO> success, TemplateApplyCartContext context) {
        if (CollUtil.isEmpty(success)) {
            return;
        }
        List<String> itemCodeList =
                success.stream().filter(item -> StrUtil.isNotBlank(item.getItemCode())).map(DemandOrderApplySuccessRespVO::getItemCode).distinct().collect(Collectors.toList());

        if (CollUtil.isEmpty(context.getItemRpcDtoByParam())) {
            throw new BusinessException("请联系管理员配置商品权限");
        }
        List<ItmItemBaseRpcDTO> itemRpcDtoByParam =
                context.getItemRpcDtoByParam().stream().filter(item -> itemCodeList.contains(item.getItemCode())).collect(Collectors.toList());

        Map<String, ItmItemBaseRpcDTO> itemCodeEntityMap =
                itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode
                        , Function.identity()));
        success.forEach(item -> {
            String itemCode = item.getItemCode();
            if (itemCodeEntityMap.containsKey(itemCode)) {
                ItmItemBaseRpcDTO itmItemRpcDTO = itemCodeEntityMap.get(itemCode);
                item.setSpuId(itmItemRpcDTO.getSpuId());
                item.setSpuItemCode(itmItemRpcDTO.getSpuCode());
                item.setSpuItemName(itmItemRpcDTO.getSpuName());
                item.setUom(itmItemRpcDTO.getUom());
                item.setUomName(itmItemRpcDTO.getUomName());
                if (item.getItemId() == null) {
                    item.setItemId(itmItemRpcDTO.getId());
                }
                if (StrUtil.isBlank(item.getItemName())) {
                    item.setItemName(itmItemRpcDTO.getItemName());
                }
                if (StrUtil.isBlank(item.getItemCateCode())) {
                    item.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                }
                item.setItemAttr2(itmItemRpcDTO.getItemAttr2());
                item.setSpec(itmItemRpcDTO.getSpec());
                item.setItemType(itmItemRpcDTO.getItemType2());
            }
        });

    }

    private void processItemInfo(List<DemandOrderApplySuccessRespVO> success) {
        if (CollUtil.isEmpty(success)) {
            return;
        }
        List<String> itemCodeList =
                success.stream().filter(item -> StrUtil.isNotBlank(item.getItemCode())).map(DemandOrderApplySuccessRespVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemBaseRpcParam rpcParam = new ItmItemBaseRpcParam();
        rpcParam.setItemCodes(itemCodeList);
        List<ItmItemBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemBaseRpcDtoByParam(rpcParam);
        Map<String, ItmItemBaseRpcDTO> itemCodeEntityMap =
                itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode
                        , Function.identity()));
        success.forEach(item -> {
            String itemCode = item.getItemCode();
            if (itemCodeEntityMap.containsKey(itemCode)) {
                ItmItemBaseRpcDTO itmItemRpcDTO = itemCodeEntityMap.get(itemCode);
                item.setSpuId(itmItemRpcDTO.getSpuId());
                item.setSpuItemCode(itmItemRpcDTO.getSpuCode());
                item.setSpuItemName(itmItemRpcDTO.getSpuName());
                item.setUom(itmItemRpcDTO.getUom2());
                item.setUomName(itmItemRpcDTO.getUom2Name());
                if (item.getItemId() == null) {
                    item.setItemId(itmItemRpcDTO.getId());
                }
                if (StrUtil.isBlank(item.getItemName())) {
                    item.setItemName(itmItemRpcDTO.getItemName());
                }
                if (StrUtil.isBlank(item.getItemCateCode())) {
                    item.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                }
                item.setItemAttr2(itmItemRpcDTO.getItemAttr2());
                item.setSpec(itmItemRpcDTO.getSpec());
                item.setItemType(itmItemRpcDTO.getItemType2());
            }
        });

    }

    // 小程序获取门店权限内的商品
    private List<StoreAuthorityRespDTO.ItemInfo> getPermitedItemsByStoreCodeBOH(String storeCode,
                                                                                String docType,
                                                                                String type,
                                                                                TemplateApplyCartContext context,
                                                                                List<String> itemCodeList) {
        StoreAuthorityRpcDTO storeAuthorityRpcDTO = new StoreAuthorityRpcDTO();
        storeAuthorityRpcDTO.setStoreCode(storeCode);
        storeAuthorityRpcDTO.setDocType(docType);
        StoreAuthorityRespDTO data =
                storeAuthorityService.getStoreAuthorityDataBOH(storeAuthorityRpcDTO, context, itemCodeList, type);
        if (data == null) {
            return new ArrayList<>();
        } else {
            return data.getItemInfos();
        }
    }
}
