package com.elitesland.scp.application.web.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppLoginAccountStoreProtocolRespVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStoreProtocolAgreeParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoRespVO;
import com.elitesland.scp.application.service.app.AppStoreProtocolService;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.application.web.app.enums.ArticleCategory;
import com.elitesland.scp.application.web.app.enums.LoginAccountType;
import com.elitesland.scp.application.web.app.util.AccountIdentifierUtil;
import com.elitesland.scp.domain.service.article.ArticleManageService;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.vo.article.ArticleInfoPagingParam;
import com.elitesland.scp.domain.vo.article.ArticleInfoRespVO;
import com.elitesland.scp.provider.authority.ScpmansAuthorityRpcServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 09月 16日 15:12
 * @version: 1.0
 */
@RestController
@RequestMapping("/app/store/protocol")
@RequiredArgsConstructor
@Api(value = "app-门店登陆协议管理", tags = {"app-门店登陆协议管理"})
@Slf4j
public class AppStoreProtocolContorller {

    private final AppStoreProtocolService appStoreProtocolService;
    private final ArticleManageService articleManageService;

    @PostMapping("/agree")
    @ApiOperation("门店协议同意状态更新")
    public ApiResult<?> setStoreProtocolAgreeStatus(@RequestBody AppStoreProtocolAgreeParamVO param) {
        appStoreProtocolService.setProtocolAgreeStatus(param);
        return ApiResult.ok();
    }

    @GetMapping("/search/{account}")
    @ApiOperation("查询协议状态")
    public ApiResult<AppLoginAccountStoreProtocolRespVO> search(@PathVariable("account") String account) {
        return ApiResult.ok(appStoreProtocolService.queryStoreProtocolByAccount(account));
    }

    @GetMapping("/query")
    @ApiOperation("门店协议查询")
    public ApiResult<?> serchStoreProtocol() {
        return ApiResult.ok(appStoreProtocolService.serchStoreProtocol());
    }

    @GetMapping("/queryByCategoryName")
    @ApiOperation("门店协议通过入参查询")
    public ApiResult<?> queryByParam(@RequestParam String categoryName) {
        return ApiResult.ok(appStoreProtocolService.serchStoreProtocolByName(categoryName));
    }

    /**
     * 查询 小程序个人中心的协议分类 下的文章列表
     *
     * @return
     */
    @PostMapping("/article/search")
    @ApiOperation("门店协议文档列表及内容查询")
    public ApiResult<PagingVO<ArticleInfoRespVO>> articleInfoSearch(@RequestBody ArticleInfoPagingParam searchParam) {
        switch (searchParam.getCategoryCode()) {
            case "0":
                searchParam.setCategoryName(ArticleCategory.ARTICLE_CODE_APP_STORE_PROTOCOL.getDescription());
                break;
            case "1":
                searchParam.setCategoryName(ArticleCategory.ARTICLE_CODE_PERSONAL_CENTER_PROTOCOL.getDescription());
                break;
            default:
                break;
        }
        if (searchParam.getShowFlag() == null) {
            searchParam.setShowFlag("DISPLAY");
        }
        return ApiResult.ok(articleManageService.infoSearch(searchParam));
    }


}
