package com.elitesland.scp.application.web.boh;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invTrn.StoreCanRtnQtyRpcDTO;
import com.elitesland.scp.application.facade.vo.boh.*;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "门店收退货接口")
@RestController
@RequestMapping(value = "/applet/rt", produces = MediaType.APPLICATION_JSON_VALUE)
@RequiredArgsConstructor
public class StoreReceiveController {

    private final StoreReceiveService storeReceiveService;

    @ApiOperation(value = "分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<StoreReceivePageVO>> page(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] page  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(storeReceiveService.page(paramVO));
    }

    @ApiOperation(value = "分页和详情查询")
    @PostMapping(value = "/pageAndDetail")
    public ApiResult<PagingVO<StoreReceivePageVO>> pageAndDetail(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] pageAndDetail  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(storeReceiveService.pageAndDetail(paramVO));
    }

    @ApiOperation(value = "列表按照仓发和直发分类")
    @PostMapping(value = "/classifyByWhOrDirect")
    public ApiResult<StoreReceiveCategoryVO> classifyByWhOrDirect(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] classifyByWhOrDirect  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(storeReceiveService.classifyByWhOrDirect(paramVO));
    }

    @ApiOperation(value = "列表按照仓发和直发分类展示商品")
    @PostMapping(value = "/classifyItemByWhOrDirect")
    public ApiResult<StoreReceiveCategoryInfoVO> classifyItemByWhOrDirect(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] classifyItemByWhOrDirect  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(storeReceiveService.classifyItemByWhOrDirect(paramVO));
    }

    @ApiOperation(value = "详情")
    @GetMapping(value = "/detail")
    public ApiResult<StoreReceiveDetailVO> detail(@RequestParam("docId") Long docId) {
        log.info("[SCP-RT] detail  paramVO ={}", docId);
        return ApiResult.ok(storeReceiveService.find(docId));
    }

    @ApiOperation(value = "收货确认")
    @PostMapping(value = "/receiveConfirm")
    public ApiResult<?> receiveConfirm(@RequestBody StoreReceiveConfirmParam paramVO) {
        log.info("[SCP-RT] receiveConfirm  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        storeReceiveService.receiveConfirm(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "退货确认")
    @PostMapping(value = "/rtnConfirm")
    public ApiResult<?> rtnConfirm(@RequestBody StoreRtnConfirmParam paramVO) {
        log.info("[SCP-RT] rtnConfirm  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        storeReceiveService.rtnConfirm(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "退货申请")
    @PostMapping(value = "/rtnApply")
    public ApiResult<?> rtnApply(@RequestBody StoreRtnApplyParam paramVO) {
        log.info("[SCP-RT] rtnApply  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        storeReceiveService.rtnApply(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "赔付申请")
    @PostMapping(value = "/reFundApply")
    public ApiResult<?> reFundApply(@RequestBody List<StoreRtnApplyParam> paramVOList) {
        log.info("[SCP-RT] reFundApply  paramVOList ={}", JSONUtil.toJsonStr(paramVOList));
        RtnApplyResult rtnApplyResult = storeReceiveService.reFundApply(paramVOList);
        List<RtnApplyResult.FailedRtnApply> failedList = rtnApplyResult.getFailedList();
        if (failedList != null && !failedList.isEmpty()) {
            log.info("[SCP-RT] reFundApply  failedList ={}", JSONUtil.toJsonStr(failedList));
        }
        return ApiResult.ok();
    }

    @ApiOperation(value = "是否可以退单")
    @GetMapping(value = "/rtnPermission")
    public ApiResult<Boolean> rtnPermission(@RequestParam("orderId") Long orderId) {
        log.info("[SCP-RT] rtnPermission paramVOList ={}", orderId);
        Boolean b = storeReceiveService.rtnPermission(orderId);
        return ApiResult.ok(b);
    }

    @ApiOperation(value = "通过订货单申请退货")
    @PostMapping(value = "/rtnApplyByOrder")
    public ApiResult<?> rtnApplyByOrder(@RequestBody List<StoreRtnApplyParam> paramVOList) {
        log.info("[SCP-RT] rtnApplyByOrder  paramVO ={}", JSONUtil.toJsonStr(paramVOList));
        RtnApplyResult rtnApplyResult = storeReceiveService.rtnApplyByOrder(paramVOList);
        List<RtnApplyResult.FailedRtnApply> failedList = rtnApplyResult.getFailedList();
        if (failedList != null && !failedList.isEmpty()) {
            log.info("[SCP-RT] rtnApplyByOrder  failedList ={}", JSONUtil.toJsonStr(failedList));
        }
        return ApiResult.ok();
    }

    @ApiOperation(value = "可退货数量")
    @GetMapping(value = "/canRtn")
    public ApiResult<List<StoreCanRtnQtyRpcDTO>> canRtn(@RequestParam("docId") Long docId) {
        log.info("[SCP-RT] canRtn  paramVO ={}", docId);
        List<StoreCanRtnQtyRpcDTO> rpcDTOS = storeReceiveService.canRtn(docId);
        return ApiResult.ok(rpcDTOS);
    }

    @ApiOperation(value = "作废")
    @PostMapping(value = "/abort")
    public ApiResult abort(@RequestParam("docId") Long docId) {
        log.info("[SCP-RT] abort  paramVO ={}", docId);
        storeReceiveService.abort(docId);
        return ApiResult.ok();
    }
}
