package com.elitesland.scp.domain.convert;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.UserDTO;
import com.elitesland.scp.domain.convert.order.CustomMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:25
 * @Description:
 */
@Mapper(config = CustomMapperConfig.class)
public interface UserConvert {
    UserConvert INSTANCE = Mappers.getMapper(UserConvert.class);

    /**
     * 转为用户信息
     *
     * @param userDTO 系统用户信息
     * @return 用户信息
     */
    UserDTO convert(SysUserDTO userDTO);

    /**
     * 转为用户信息
     *
     * @param userVO 当前用户
     * @return 用户信息
     */
    CurrentUserDTO convert(GeneralUserDetails userVO);
}
