package com.elitesland.scp.domain.entity.item;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;


@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_cate_item_sale_scope_region")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_cate_item_sale_scope_region", comment = "报货商品可售范围区域")
public class ScpCateItemSaleScopeRegionDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint")
    @Comment("主表id")
    private Long masId;

    @Comment(value = "适用区域编码")
    @Column(nullable = false)
    private String regionCode;

}