package com.elitesland.scp.domain.service.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeRegionDO;
import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeStoreDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.item.ScpCateItemSaleScopeRegionRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemSaleScopeStoreRepo;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.param.ScpCateItemSaleScopeSaveRpcParam;
import com.elitesland.scp.param.ScpCateItemUpdateRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.service.item.CateItemRpcService;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/3 11:40 上午
 * @version:v1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
@RestController
@RequestMapping(ScpApplication.URI_PREFIX + CateItemRpcService.PATH)
public class ScpCateItemDomainServiceImpl implements ScpCateItemDomainService, CateItemRpcService {
    private final ScpCateItemRepo scpCateItemRepo;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpCateItemSaleScopeStoreRepo scpCateItemSaleScopeStoreRepo;
    private final ScpCateItemSaleScopeRegionRepo scpCateItemSaleScopeRegionRepo;


    @Override
    public void saveBatch(List<ScpCateItemDO> scpCateItemDOS) {
        scpCateItemRepo.saveAll(scpCateItemDOS);
    }

    @Override
    public void delete(List<Long> ids) {
        scpCateItemRepo.deleteAllByIdInBatch(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(scpCateItemRepoProc.queryDto(cateItemRpcParam));

    }

    @Override
    public List<String> existByItemCodes(List<String> itemCodes) {
        return scpCateItemRepoProc.queryByItemCodes(itemCodes);
    }

    @Override
    public ApiResult<List<String>> findItemCodesBy(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(scpCateItemRepoProc.queryItemCode(cateItemRpcParam));
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> listByParam(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    @Override
    public ApiResult<String> saveSaleScope(List<ScpCateItemSaleScopeSaveRpcParam> paramList) {
        log.info("保存可售范围，参数：{}", JSONObject.toJSONString(paramList));
        for (ScpCateItemSaleScopeSaveRpcParam param : paramList) {
            List<ScpCateItemSaleScopeRegionDO> allByRegionCode = scpCateItemSaleScopeRegionRepo.findAllByRegionCode(param.getRegionCode());
            if (CollUtil.isEmpty(allByRegionCode)) {
                log.info("{}区域不需要设置可售范围", param.getRegionCode());
                continue;
            }

            List<Long> masIdList = allByRegionCode.stream().map(ScpCateItemSaleScopeRegionDO::getMasId).distinct().toList();
            List<Long> newMasIdList = new ArrayList<>();
            List<ScpCateItemSaleScopeStoreDO> allByMasIdInAndStoreCode = scpCateItemSaleScopeStoreRepo.findAllByMasIdInAndStoreCode(masIdList, param.getStoreCode());
            if (CollUtil.isNotEmpty(allByMasIdInAndStoreCode)) {
                List<Long> collect = allByMasIdInAndStoreCode.stream().map(ScpCateItemSaleScopeStoreDO::getMasId).distinct().toList();
                masIdList.forEach(masId -> {
                    if (!collect.contains(masId)) {
                        newMasIdList.add(masId);
                    }
                });
            } else {
                newMasIdList.addAll(masIdList);
            }

            log.info("可售范围门店添加商品的id，masIdList:{}", newMasIdList);
            if (CollUtil.isNotEmpty(newMasIdList)) {
                List<ScpCateItemSaleScopeStoreDO> collect = new ArrayList<>();
                for (Long masId : newMasIdList) {
                    ScpCateItemSaleScopeStoreDO scpCateItemSaleScopeStoreDO = new ScpCateItemSaleScopeStoreDO();
                    scpCateItemSaleScopeStoreDO.setMasId(masId);
                    scpCateItemSaleScopeStoreDO.setStoreCode(param.getStoreCode());
                    collect.add(scpCateItemSaleScopeStoreDO);
                }
                if (CollUtil.isNotEmpty(collect)) {
                    scpCateItemSaleScopeStoreRepo.saveAll(collect);
                }
            }
        }

        return ApiResult.ok("设置成功");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> refreshItemType2(List<ScpCateItemUpdateRpcParam> paramList) {
        if(CollectionUtils.isNotEmpty(paramList)){
            for(ScpCateItemUpdateRpcParam param: paramList){
                scpCateItemRepoProc.updateItemType2(param.getItemCode(), param.getItemType2());
            }
        }
        return ApiResult.ok("更新成功");
    }

    @Override
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        scpCateItemRepoProc.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        long count = scpCateItemRepoProc.countItem(paramVO);
        if (count > 0) {
            var itemList = scpCateItemRepoProc.queryItemList(paramVO);
            List<ScpOrderSettingRespVO> settingList = scpOrderSettingDomainService.findEnabledSetting();
            if (CollUtil.isEmpty(settingList)) {
                return new PagingVO<>(count, itemList);
            }
            var settingMap = settingList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).collect(Collectors.groupingBy(
                    row -> StrUtil.split(row.getItemCate(), ",").get(0)));

            Map<Long, List<ItmItemScpBaseRpcDTO>> itemMap = getItemMap(itemList);
            itemList.forEach(row -> {
                if (itemMap.containsKey(row.getItemId())) {
                    var itmItemScpBaseRpcDTO = itemMap.get(row.getItemId()).get(0);
                    row.setSpec(itmItemScpBaseRpcDTO.getSpec());
                    List<ItmItemAttachmentRpcDTO> spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                    if (CollUtil.isNotEmpty(spuAttchmentList)) {
                        //商品图片取spu主图
                        Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        if (first.isPresent()) {
                            row.setUrl(first.get().getUrl());
                        }
                    }
                    row.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
                    row.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
                    row.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
                    row.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                    row.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
                    row.setUom(itmItemScpBaseRpcDTO.getUom2());
                    row.setItemTyp2(itmItemScpBaseRpcDTO.getItemType2());
                    List<ScpOrderSettingRespVO> settingRespVOS = settingMap.get(itmItemScpBaseRpcDTO.getItemType());
                    if (CollUtil.isEmpty(settingRespVOS)) {
                        return;
                    }
                    ScpOrderSettingRespVO setting = settingRespVOS.get(0);
                    row.setDocType(setting.getDocType());
                }
            });
            Map<String, List<ScpCateItemRespVO>> businessTypeMap = itemList.stream().collect(Collectors.groupingBy(ScpCateItemRespVO::getBusinessType));
            // 循环businessTypeMap
            Map<String, AppItemPriceRespVO> allPriceMap = new HashMap<>();
            businessTypeMap.forEach((k, v) -> {
                ScpOrderSettingRespVO setting = scpOrderSettingDomainService.findCacheByBusinessType(k, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                // 根据docType查询对应的单据配置
                var priceParamVOS = v.stream().map(row -> {
                    AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                    priceParamVO.setItemCode(row.getItemCode());
                    priceParamVO.setItemId(row.getItemId());
                    priceParamVO.setItemCateCode(row.getItemCateCode());
                    priceParamVO.setUom(row.getUom());
                    priceParamVO.setItemType2(row.getItemTyp2());
                    return priceParamVO;
                }).collect(Collectors.toList());
                Map<String, AppItemPriceRespVO> priceMap = commonPriceService.getNewPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), setting,
                        ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                allPriceMap.putAll(priceMap);
            });
            itemList.forEach(row -> {
                if (!allPriceMap.containsKey(row.getItemCode())) {
                    return;
                }
                row.setPrice(allPriceMap.get(row.getItemCode()).getPrice());
            });

            return new PagingVO<>(count, itemList);
        }
        return new PagingVO<>();
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        long count = scpCateItemRepoProc.countItem(paramVO);
        if (count > 0) {
            List<ScpCateItemPageVO> scpCateItemPageVOS = scpCateItemRepoProc.skuPage(paramVO);
            return new PagingVO<>(count, scpCateItemPageVOS);
        }
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSorNo(Long id, Integer sorNo) {
        scpCateItemRepoProc.updateSortNoById(sorNo, id);
    }

    private Map<Long, List<ItmItemScpBaseRpcDTO>> getItemMap(List<ScpCateItemRespVO> cateItemList) {
        List<Long> itemIds = cateItemList.stream().map(ScpCateItemRespVO::getItemId).collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> baseRpcDTOList = rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isNotEmpty(baseRpcDTOList)) {
            return baseRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getId));
        }
        return new HashMap<>();
    }
}
