package com.elitesland.scp.domain.vo.survey;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(description = "问卷新增编辑入参")
@Data
public class SurveySaveParam implements Serializable {
    private static final long serialVersionUID = 632396646377721743L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("问卷标题")
    private String surveyTitle;

    @ApiModelProperty("问卷描述")
    private String surveyDesc;

    @ApiModelProperty("开始时间")
    private LocalDateTime beginTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("问卷状态")
    private String surveyStatus;

    @ApiModelProperty("发布人")
    private Long publisherId;

    @ApiModelProperty("发布人")
    private String publisherName;

    @ApiModelProperty("填写数量")
    private Integer fillCount;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("是否必填")
    private Boolean required;

    @ApiModelProperty("问题列表")
    private List<SurveyQuestionSaveParam> questionList;
}
