/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.scp.application.facade.vo.param.app.AppLoginAccountStoreProtocolRespVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStoreProtocolAgreeParamVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoRespVO;
import com.elitesland.scp.application.service.app.AppStoreProtocolService;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityManager;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.application.web.app.enums.LoginAccountType;
import com.elitesland.scp.application.web.app.util.AccountIdentifierUtil;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.article.ArticleManageService;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.survey.SurveyService;
import com.elitesland.scp.domain.vo.survey.SurveyCheckRespVO;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreProtocolSaveRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import feign.RequestTemplate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppStoreProtocolServiceImpl
implements AppStoreProtocolService {
    private static final Logger log = LoggerFactory.getLogger(AppStoreProtocolServiceImpl.class);
    private final ScpsmanInfoService scpsmanInfoService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final OrgStoreRpcService rmiOrgStoreRpcService;
    private final EmployeeRpcService employeeRpcService;
    private final RedisTemplate redisClient;
    private final ArticleManageService articleManageService;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private final TenantClientProvider tenantClientProvider;
    private final ScpsmanAuthorityManager scpsmanAuthorityManager;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final SurveyService surveyService;
    @Value(value="${app.protocol.tenantCode:}")
    private String tenantCode;
    private static final List<String> SCPSMAN_TYPE_CHECK_LIST = List.of(UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode(), UdcEnum.SALE_SCPSMAN_TYPE_SHOPASSISTANT.getValueCode(), UdcEnum.SALE_SCPSMAN_TYPE_CONTRACTOR.getValueCode());
    private static final String ARTICLE_CODE_APP_STORE_PROTOCOL = "\u5c0f\u7a0b\u5e8f\u767b\u5f55\u9875\u534f\u8bae";

    @Override
    public AppLoginAccountStoreProtocolRespVO queryStoreProtocolByAccount(String account) {
        log.info("\u5f00\u59cb\u6839\u636e\u8d26\u53f7\u67e5\u8be2\u95e8\u5e97\u534f\u8bae\uff0c\u8d26\u53f7: {}", (Object)account);
        AppLoginAccountStoreProtocolRespVO protocolRespVO = this.getProtocolRespVO(account);
        SysTenantDTO sysTenantDTO = TenantClient.getTenant((String)this.tenantCode);
        SysTenantDTO sessionTenant = this.tenantClientProvider.getSessionTenant();
        log.info("\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff1a{},{}", (Object)sessionTenant, (Object)sysTenantDTO);
        TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
        try {
            String cleanAccount = account.trim();
            if (StringUtils.isEmpty((CharSequence)cleanAccount)) {
                log.warn("\u8d26\u53f7\u4e3a\u7a7a\u6216\u65e0\u6548: {}", (Object)account);
                protocolRespVO.setMsg("\u8d26\u53f7\u4e3a\u7a7a\u6216\u65e0\u6548");
                AppLoginAccountStoreProtocolRespVO appLoginAccountStoreProtocolRespVO = protocolRespVO;
                return appLoginAccountStoreProtocolRespVO;
            }
            List<SalesmanInfoRespVO> salesmanInfoRespVOS = this.getSalesmanInfoRespVOS(cleanAccount, protocolRespVO);
            if (CollectionUtils.isEmpty(salesmanInfoRespVOS)) {
                log.warn("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\uff0c\u8d26\u53f7: {}", (Object)cleanAccount);
                protocolRespVO.setMsg("\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f");
                AppLoginAccountStoreProtocolRespVO appLoginAccountStoreProtocolRespVO = protocolRespVO;
                return appLoginAccountStoreProtocolRespVO;
            }
            log.info("\u67e5\u8be2\u5230\u95e8\u5e97\u534f\u8bae\u8ba2\u8d27\u5458\u4fe1\u606f\uff1a{}", salesmanInfoRespVOS);
            this.processSalesmanInfo(salesmanInfoRespVOS, protocolRespVO);
            List storeBaseRpcDTOS = (List)this.rmiOrgStoreRpcService.findSimpleByCodes(List.of(account)).computeData();
            if (CollectionUtils.isNotEmpty((Collection)storeBaseRpcDTOS)) {
                OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)storeBaseRpcDTOS.get(0);
                if (orgStoreBaseRpcDTO != null) {
                    protocolRespVO.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
                    protocolRespVO.setStoreId(orgStoreBaseRpcDTO.getId());
                    protocolRespVO.setProtocolAgreeStatus(orgStoreBaseRpcDTO.getProtocolAgreeStatus());
                    protocolRespVO.setProtocolAgreeUserName(orgStoreBaseRpcDTO.getLegalName());
                    protocolRespVO.setProtocolAgreeUserPhone(orgStoreBaseRpcDTO.getLegalPhone());
                    protocolRespVO.setSuccess(true);
                } else {
                    this.processStoreInfo(salesmanInfoRespVOS, protocolRespVO);
                }
            } else {
                this.processStoreInfo(salesmanInfoRespVOS, protocolRespVO);
            }
            log.info("\u6210\u529f\u67e5\u8be2\u5230{}\u6761\u95e8\u5e97\u534f\u8bae\u4fe1\u606f", (Object)salesmanInfoRespVOS.size());
            List<SurveyCheckRespVO> surveyList = this.surveyService.findSurvey(account, Collections.singletonList(protocolRespVO.getStoreCode()));
            protocolRespVO.setSurvey(CollectionUtils.isEmpty(surveyList) ? null : surveyList.get(0));
            log.info("\u67e5\u8be2\u95ee\u5377\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(surveyList));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\u5f02\u5e38\uff0c\u8d26\u53f7: {}", (Object)account, (Object)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\u5f02\u5e38");
        }
        finally {
            TenantContextHolder.clearCurrentTenant();
        }
        return protocolRespVO;
    }

    @Override
    @Transactional
    public String setProtocolAgreeStatus(AppStoreProtocolAgreeParamVO param) {
        log.info("\u5f00\u59cb\u8bbe\u7f6e\u95e8\u5e97\u534f\u8bae\u540c\u610f\u72b6\u6001\uff0c\u53c2\u6570: {}", (Object)param);
        try {
            SysTenantDTO sysTenantDTO = TenantClient.getTenant((String)this.tenantCode);
            log.info("\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff1a{}", (Object)sysTenantDTO);
            TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
            List storeBaseRpcDTOS = (List)this.rmiOrgStoreRpcService.findSimpleByCodes(List.of(param.getStoreCode())).computeData();
            if (CollectionUtils.isEmpty((Collection)storeBaseRpcDTOS)) {
                log.warn("\u95e8\u5e97\u4e0d\u5b58\u5728\uff0c\u95e8\u5e97\u7f16\u7801: {}", (Object)param.getStoreCode());
                throw new BusinessException("\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            Boolean protocolAgreeStatus = ((OrgStoreBaseRpcDTO)storeBaseRpcDTOS.get(0)).getProtocolAgreeStatus();
            if (Boolean.TRUE.equals(protocolAgreeStatus)) {
                String string = param.getStoreCode();
                return string;
            }
            OrgStoreProtocolSaveRpcParam saveRpcParam = new OrgStoreProtocolSaveRpcParam();
            saveRpcParam.setStoreCode(param.getStoreCode());
            saveRpcParam.setProtocolAgreeStatus(Boolean.TRUE);
            saveRpcParam.setProtocolAgreeTime(LocalDateTime.now());
            saveRpcParam.setProtocolAgreeUserName(param.getProtocolAgreeUserName());
            saveRpcParam.setProtocolAgreeUserPhone(param.getProtocolAgreeUserPhone());
            this.saveProtocol(saveRpcParam);
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        finally {
            TenantContextHolder.clearCurrentTenant();
        }
        return param.getStoreCode();
    }

    private void saveProtocol(OrgStoreProtocolSaveRpcParam saveRpcParam) {
        log.info("\u5f00\u59cb\u8bbe\u7f6e\u95e8\u5e97\u534f\u8bae\u540c\u610f\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)saveRpcParam));
        this.rmiOrgStoreRpcService.saveStoreProtocolStatus(saveRpcParam);
    }

    @Override
    public String serchStoreProtocol() {
        try {
            SysTenantDTO sysTenantDTO = TenantClient.getTenant((String)this.tenantCode);
            log.info("\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff1a{}", (Object)sysTenantDTO);
            TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
            String string = this.articleManageService.queryAppStoreProtocolArticle(ARTICLE_CODE_APP_STORE_PROTOCOL);
            return string;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\u5f02\u5e38");
        }
        finally {
            TenantContextHolder.clearCurrentTenant();
        }
    }

    @Override
    public String serchStoreProtocolByName(String categoryName) {
        try {
            return this.articleManageService.queryAppStoreProtocolArticle(categoryName);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\u5f02\u5e38");
        }
    }

    private void processStoreInfo(List<SalesmanInfoRespVO> salesmanInfoRespVOS, AppLoginAccountStoreProtocolRespVO protocolRespVO) {
        SalesmanInfoRespVO salesmanInfoRespVO = salesmanInfoRespVOS.get(0);
        Optional infoDO = this.scpsmanInfoRepo.findById(salesmanInfoRespVO.getId());
        if (infoDO.isEmpty()) {
            protocolRespVO.setSuccess(false);
            protocolRespVO.setMsg("\u672a\u67e5\u8be2\u5230\u8d26\u53f7");
            return;
        }
        Map<String, OrgStoreBaseRpcDTO> storeMap = this.scpsmanAuthorityManager.queryStoreList(null, (ScpsmanInfoDO)((Object)infoDO.get()), 1);
        log.info("\u534f\u8bae\u95e8\u5e97\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(storeMap));
        if (storeMap.isEmpty()) {
            protocolRespVO.setSuccess(false);
            protocolRespVO.setMsg("\u672a\u67e5\u8be2\u5230\u95e8\u5e97");
            return;
        }
        Optional firstEntry = storeMap.entrySet().stream().findFirst();
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((Map.Entry)firstEntry.get()).getValue();
        if (orgStoreBaseRpcDTO == null) {
            protocolRespVO.setSuccess(false);
            protocolRespVO.setMsg("\u672a\u67e5\u8be2\u5230\u95e8\u5e97");
        }
        protocolRespVO.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
        protocolRespVO.setStoreId(orgStoreBaseRpcDTO.getId());
        protocolRespVO.setProtocolAgreeStatus(orgStoreBaseRpcDTO.getProtocolAgreeStatus());
        protocolRespVO.setProtocolAgreeUserName(orgStoreBaseRpcDTO.getLegalName());
        protocolRespVO.setProtocolAgreeUserPhone(orgStoreBaseRpcDTO.getLegalPhone());
        protocolRespVO.setSuccess(true);
    }

    private void processSalesmanInfo(List<SalesmanInfoRespVO> salesmanInfoRespVOS, AppLoginAccountStoreProtocolRespVO protocolRespVO) {
        if (SCPSMAN_TYPE_CHECK_LIST.contains(salesmanInfoRespVOS.get(0).getScpsmanType())) {
            protocolRespVO.setForceCheck(Boolean.TRUE);
        } else {
            protocolRespVO.setForceCheck(Boolean.FALSE);
        }
        SysEmployeeDetailDTO employeeDetailDTO = (SysEmployeeDetailDTO)this.employeeRpcService.getDetailByCode(salesmanInfoRespVOS.get(0).getScpsmanNo()).computeData();
        protocolRespVO.setLoginName(employeeDetailDTO.getFullName());
        protocolRespVO.setMobile(employeeDetailDTO.getPhone());
        protocolRespVO.setScpmanNo(salesmanInfoRespVOS.get(0).getScpsmanNo());
    }

    private void cacheResult(String account, AppLoginAccountStoreProtocolRespVO result) {
        if (result.getSuccess().booleanValue()) {
            String key = this.getKey(account);
            try {
                this.redisClient.opsForValue().set((Object)key, (Object)JSON.toJSONString((Object)result));
                log.debug("\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\u7f13\u5b58\u6210\u529f\uff0c\u8d26\u53f7: {}", (Object)account);
            }
            catch (Exception e) {
                log.warn("\u7f13\u5b58\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\u5f02\u5e38\uff0c\u8d26\u53f7: {}\uff0c\u9519\u8bef: {}", (Object)account, (Object)e.getMessage());
            }
        }
    }

    @NotNull
    private String getKey(String account) {
        String key = "APP_LOGIN_PROTOCOL:" + account;
        return key;
    }

    private List<SalesmanInfoRespVO> getSalesmanInfoRespVOS(String cleanAccount, AppLoginAccountStoreProtocolRespVO protocolRespVO) {
        LoginAccountType loginAccountType = AccountIdentifierUtil.identifyAccountType(cleanAccount);
        ArrayList<SalesmanInfoRespVO> salesmanInfoRespVOS = new ArrayList();
        switch (loginAccountType) {
            case PHONE_NUMBER: {
                log.debug("\u8bc6\u522b\u4e3a\u624b\u673a\u53f7\u767b\u5f55\uff0c\u624b\u673a\u53f7: {}", (Object)cleanAccount);
                salesmanInfoRespVOS = this.scpsmanInfoService.queryByMobile(cleanAccount);
                protocolRespVO.setAccountType(LoginAccountType.PHONE_NUMBER.name());
                break;
            }
            case EMPLOYEE_ID: {
                log.debug("\u8bc6\u522b\u4e3a\u5458\u5de5\u8d26\u53f7\u767b\u5f55\uff0c\u5458\u5de5\u53f7: {}", (Object)cleanAccount);
                salesmanInfoRespVOS = this.scpsmanInfoService.queryByLoginAccount(cleanAccount);
                protocolRespVO.setAccountType(LoginAccountType.EMPLOYEE_ID.name());
                break;
            }
            default: {
                log.warn("\u65e0\u6cd5\u8bc6\u522b\u7684\u8d26\u53f7\u683c\u5f0f: {}", (Object)cleanAccount);
                salesmanInfoRespVOS = this.tryBothQueryMethods(cleanAccount, protocolRespVO);
            }
        }
        return salesmanInfoRespVOS;
    }

    @NotNull
    private AppLoginAccountStoreProtocolRespVO getProtocolRespVO(String account) {
        AppLoginAccountStoreProtocolRespVO protocolRespVO = new AppLoginAccountStoreProtocolRespVO();
        protocolRespVO.setLoginAccount(account);
        protocolRespVO.setProtocolAgreeStatus(false);
        protocolRespVO.setSuccess(false);
        return protocolRespVO;
    }

    private AppLoginAccountStoreProtocolRespVO getFromCache(String account) {
        String key = this.getKey(account);
        try {
            log.debug("\u5c1d\u8bd5\u4eceRedis\u4e2d\u83b7\u53d6\u95e8\u5e97\u534f\u8bae\u4fe1\u606fkey\uff0c\u8d26\u53f7: {}", (Object)key);
            String cachedJson = (String)this.redisClient.opsForValue().get((Object)key);
            if (cachedJson != null) {
                log.info("\u4eceRedis\u4e2d\u83b7\u53d6\u95e8\u5e97\u534f\u8bae\u4fe1\u606f\u6210\u529f\uff0c\u8d26\u53f7: {}", (Object)account);
                return (AppLoginAccountStoreProtocolRespVO)JSON.parseObject((String)cachedJson, AppLoginAccountStoreProtocolRespVO.class);
            }
        }
        catch (Exception e) {
            log.warn("\u4eceRedis\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u8d26\u53f7: {}\uff0c\u9519\u8bef: {}", (Object)account, (Object)e.getMessage());
        }
        return null;
    }

    private List<SalesmanInfoRespVO> tryBothQueryMethods(String account, AppLoginAccountStoreProtocolRespVO protocolRespVO) {
        List<Object> result = new ArrayList();
        result = this.scpsmanInfoService.queryByLoginAccount(account);
        if (CollectionUtils.isNotEmpty(result)) {
            log.debug("\u901a\u8fc7\u5458\u5de5\u53f7\u67e5\u8be2\u6210\u529f: {}", (Object)account);
            protocolRespVO.setLoginAccount(LoginAccountType.EMPLOYEE_ID.name());
            return result;
        }
        result = this.scpsmanInfoService.queryByMobile(account);
        if (CollectionUtils.isNotEmpty(result)) {
            log.debug("\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u6210\u529f: {}", (Object)account);
            protocolRespVO.setLoginAccount(LoginAccountType.PHONE_NUMBER.name());
            return result;
        }
        return result;
    }

    public void apply(RequestTemplate template) {
        if (!this.tenantClientProvider.enabledTenant()) {
            template.removeHeader("X-Tenant-Id");
        } else {
            SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
            if (tenant == null) {
                template.removeHeader("X-Tenant-Id");
            } else {
                template.header("X-Tenant-Id", new String[]{tenant.getId().toString()});
            }
        }
    }

    public AppStoreProtocolServiceImpl(ScpsmanInfoService scpsmanInfoService, ScpDemandAuthorityService scpDemandAuthorityService, OrgStoreRpcService rmiOrgStoreRpcService, EmployeeRpcService employeeRpcService, RedisTemplate redisClient, ArticleManageService articleManageService, TenantDataIsolateProvider tenantDataIsolateProvider, TenantClientProvider tenantClientProvider, ScpsmanAuthorityManager scpsmanAuthorityManager, ScpsmanInfoRepo scpsmanInfoRepo, SurveyService surveyService) {
        this.scpsmanInfoService = scpsmanInfoService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.employeeRpcService = employeeRpcService;
        this.redisClient = redisClient;
        this.articleManageService = articleManageService;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
        this.tenantClientProvider = tenantClientProvider;
        this.scpsmanAuthorityManager = scpsmanAuthorityManager;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
        this.surveyService = surveyService;
    }
}

