/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.export;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationImportVO;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScpWhNetRelationImportServiceImpl
implements DataImport<ScpWhNetRelationImportVO> {
    private static final Logger log = LoggerFactory.getLogger(ScpWhNetRelationImportServiceImpl.class);
    private final ScpWhNetRelationService scpWhNetRelationService;

    public String getTmplCode() {
        return "scp_wh_net_relation_import";
    }

    public List<String> executeImport(List<ScpWhNetRelationImportVO> dataList, int startRowIndex) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List<String> errorMsg = this.scpWhNetRelationService.executeImport(dataList, startRowIndex);
            if (errorMsg != null) {
                log.info("\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u5bfc\u5165\u5b8c\u6210,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:{}", (Object)JSONUtil.toJsonStr(errorMsg));
            } else {
                log.info("\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u5bfc\u5165\u5b8c\u6210,\u672a\u53d1\u751f\u9519\u8bef");
            }
            return errorMsg;
        }
        catch (Exception e) {
            for (ScpWhNetRelationImportVO entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    public Integer stepSize() {
        return 1000;
    }

    public Set<Integer> sheetNoList() {
        return Set.of(Integer.valueOf(1));
    }

    public ScpWhNetRelationImportServiceImpl(ScpWhNetRelationService scpWhNetRelationService) {
        this.scpWhNetRelationService = scpWhNetRelationService;
    }
}

