/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.template;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.scp.application.facade.vo.template.DemandOrderSaveParamVO;
import com.elitesland.scp.application.facade.vo.template.ScpDemandTemplateImportEntity;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.enums.DayOfWeekEnumHelper;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class DemandOrderTemplateImportService
implements DataImport<ScpDemandTemplateImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(DemandOrderTemplateImportService.class);
    private static final String LINE = "\n";
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u6821\u9a8c\u5f02\u5e38: {2}; ";
    private final DemandOrderTemplateService demandOrderTemplateService;
    private final TransactionTemplate transactionTemplate;
    private final RmiSysUDCService rmiSysUDCService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiItemService rmiItemService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final OrgRegionRpcService orgRegionRpcService;

    public Set<Integer> sheetNoList() {
        return Collections.singleton(1);
    }

    public Integer stepSize() {
        return 1000000;
    }

    public String getTmplCode() {
        return "yst_scp_demand_template_import";
    }

    public List<String> executeImport(List<ScpDemandTemplateImportEntity> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List<String> errorMsg = this.checkAndSaveData(dataList, startRowIndex);
            if (errorMsg != null) {
                log.info("\u8ba2\u8d27\u6a21\u677f\u5bfc\u5165\u5b8c\u6210,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:{}", (Object)JSONUtil.toJsonStr(errorMsg));
            } else {
                log.info("\u8ba2\u8d27\u6a21\u677f\u5bfc\u5165\u5b8c\u6210,\u672a\u53d1\u751f\u9519\u8bef");
            }
            return errorMsg;
        }
        catch (Exception e) {
            for (ScpDemandTemplateImportEntity entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<ScpDemandTemplateImportEntity> dataList, int startRowIndex) {
        LinkedHashMap<Integer, String> errMsgMap = new LinkedHashMap<Integer, String>();
        Integer index = 0;
        for (ScpDemandTemplateImportEntity entity : dataList) {
            entity.setRowNo(index);
            errMsgMap.put(index, null);
            Integer n = index;
            index = index + 1;
        }
        log.info("startRowIndex\u7684\u503c:{}", (Object)startRowIndex);
        List<DemandOrderSaveParamVO> dataToSave = this.prepareData(dataList, errMsgMap);
        log.info("\u8ba2\u8d27\u6a21\u677f\u5bfc\u5165\uff0c\u51c6\u5907\u597d\u7684\u6570\u636e:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(dataToSave), (Object)JSONUtil.toJsonStr(errMsgMap));
        this.transactionTemplate.setPropagationBehavior(3);
        for (DemandOrderSaveParamVO vo : dataToSave) {
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    this.demandOrderTemplateService.save(vo);
                }
                catch (Exception e) {
                    log.error("\u8ba2\u8d27\u6a21\u677f\u5bfc\u5165\u62a5\u9519\uff1a" + e);
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
        }
        return new ArrayList<String>(errMsgMap.values());
    }

    List<DemandOrderSaveParamVO> prepareData(List<ScpDemandTemplateImportEntity> dataList, Map<Integer, String> errMsgMap) {
        List<String> storeCodes = dataList.stream().filter(e -> "\u95e8\u5e97".equals(e.getTypeName())).map(ScpDemandTemplateImportEntity::getWhStZoCode).distinct().collect(Collectors.toList());
        log.info("\u95e8\u5e97\u7f16\u7801\u96c6\u5408:{}", (Object)JSONUtil.toJsonStr(storeCodes));
        List<OrgStoreDetailRpcDTO> queryByStoreCodes = this.rmiOrgStoreRpcService.queryByStoreCodes(storeCodes);
        Map<String, String> storeTypeMap = queryByStoreCodes.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, OrgStoreDetailRpcDTO::getStoreType));
        Map storeDataMap = queryByStoreCodes.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, Function.identity()));
        log.info("\u95e8\u5e97\u7f16\u7801\u7c7b\u578b\u5b57\u5178:{},\u95e8\u5e97\u4fe1\u606f\u5b57\u5178\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(storeTypeMap), (Object)JSONUtil.toJsonStr(storeDataMap));
        List whCodes = dataList.stream().filter(e -> "\u4ed3\u5e93".equals(e.getTypeName())).map(ScpDemandTemplateImportEntity::getWhStZoCode).distinct().collect(Collectors.toList());
        log.info("\u4ed3\u5e93\u7f16\u7801\u96c6\u5408:{}", (Object)JSONUtil.toJsonStr(storeCodes));
        Map<Object, Object> whDataMap = new HashMap();
        InvWhRpcDtoParam param = new InvWhRpcDtoParam();
        param.setWhCodes(whCodes);
        List whData = (List)this.rmiInvStkRpcService.findWhDTOByParam(param).getData();
        if (CollUtil.isNotEmpty((Collection)whData)) {
            whDataMap = whData.stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, Function.identity()));
        }
        log.info("\u4ed3\u5e93\u4fe1\u606f\u5b57\u5178\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(whDataMap));
        List<String> itemCodeList = dataList.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getItemCode())).map(ScpDemandTemplateImportEntity::getItemCode).distinct().collect(Collectors.toList());
        log.info("\u5546\u54c1\u7f16\u7801\u96c6\u5408:{}", (Object)JSONUtil.toJsonStr(itemCodeList));
        Map<String, ItmItemRpcDTO> itemInfoMap = this.ProcessItemInfo(itemCodeList);
        log.info("\u5546\u54c1\u4fe1\u606f\u5b57\u5178:{}", (Object)JSONUtil.toJsonStr(itemInfoMap));
        ArrayList<DemandOrderSaveParamVO> resultList = new ArrayList<DemandOrderSaveParamVO>();
        Map<String, List<ScpDemandTemplateImportEntity>> detailMap = dataList.stream().collect(Collectors.groupingBy(ScpDemandTemplateImportEntity::getSeqNo));
        this.transactionTemplate.setPropagationBehavior(3);
        for (Map.Entry<String, List<ScpDemandTemplateImportEntity>> entry : detailMap.entrySet()) {
            AtomicBoolean isValid = new AtomicBoolean(true);
            DemandOrderSaveParamVO saveParamVO = new DemandOrderSaveParamVO();
            ArrayList<DemandOrderSaveParamVO.WhStZoObject> whStZoObjects = new ArrayList<DemandOrderSaveParamVO.WhStZoObject>();
            ArrayList<DemandOrderSaveParamVO.ItemObject> itemObjects = new ArrayList<DemandOrderSaveParamVO.ItemObject>();
            ScpDemandTemplateImportEntity headerEntity = entry.getValue().get(0);
            List rowNos = entry.getValue().stream().map(ScpDemandTemplateImportEntity::getRowNo).distinct().collect(Collectors.toList());
            Map<Object, Object> finalWhDataMap = whDataMap;
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    this.headerProcess(headerEntity, saveParamVO);
                    Map<String, List<ScpDemandTemplateImportEntity>> demandTypeMap = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(ScpDemandTemplateImportEntity::getDemandTypeName));
                    if (demandTypeMap.size() > 1) {
                        throw new BusinessException("\u5e8f\u53f7" + headerEntity.getSeqNo() + ",\u8981\u8d27\u7c7b\u578b\u4e0d\u4e00\u81f4");
                    }
                    for (ScpDemandTemplateImportEntity detail : (List)entry.getValue()) {
                        Integer rowNo = detail.getRowNo();
                        try {
                            this.detailProcess(detail, storeTypeMap, storeDataMap, finalWhDataMap, itemInfoMap, whStZoObjects, itemObjects);
                        }
                        catch (Exception e) {
                            isValid.set(false);
                            log.error("\u884c\u53f7:{}\u53d1\u751f\u9519\u8bef:{}", new Object[]{rowNo, e.getMessage(), e});
                            DemandOrderTemplateImportService.addErrMsg(errMsgMap, rowNo, e.getMessage());
                            transactionStatus.setRollbackOnly();
                        }
                    }
                }
                catch (Exception e) {
                    isValid.set(false);
                    log.error("\u8ba2\u5355\u5e8f\u53f7:{}\u53d1\u751f\u9519\u8bef:{}", new Object[]{entry.getKey(), e.getMessage(), e});
                    DemandOrderTemplateImportService.addErrMsg(errMsgMap, rowNos, e.getMessage());
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
            if (!isValid.get()) continue;
            saveParamVO.setWhStZoObjects(whStZoObjects);
            saveParamVO.setItemObjects(itemObjects);
            resultList.add(saveParamVO);
        }
        return resultList;
    }

    private void headerProcess(ScpDemandTemplateImportEntity headerEntity, DemandOrderSaveParamVO vo) {
        String detailedTime = headerEntity.getDetailedTime();
        this.detailedTimeCheck(detailedTime);
        if (StrUtil.isBlank((CharSequence)headerEntity.getDemandTemName())) {
            throw new BusinessException("\u6a21\u677f\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (headerEntity.getStartDate() == null || headerEntity.getEndDate() == null) {
            throw new BusinessException("\u6a21\u677f\u8d77\u6b62\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)headerEntity.getDemandTemStatusName())) {
            throw new BusinessException("\u6a21\u677f\u72b6\u6001\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        vo.setDemandTemName(headerEntity.getDemandTemName());
        vo.setStartDate(headerEntity.getStartDate());
        vo.setEndDate(headerEntity.getEndDate());
        if (StrUtil.isNotBlank((CharSequence)headerEntity.getDetailedTime())) {
            vo.setDetailedTime(DayOfWeekEnumHelper.splitAndListCodeName((String)headerEntity.getDetailedTime()));
        }
        vo.setDemandTemStatus(this.getStatusByName(headerEntity.getDemandTemStatusName()));
        vo.setRemark(headerEntity.getRemark());
        vo.setDocType(this.getDocTypeName(headerEntity.getDocTypeName()));
        vo.setType(this.getDemandTypeName(headerEntity.getDemandTypeName()));
    }

    private void detailProcess(ScpDemandTemplateImportEntity headerEntity, Map<String, String> storeTypeMap, Map<String, OrgStoreDetailRpcDTO> storeDataMap, Map<String, InvWhRpcDTO> whDataMap, Map<String, ItmItemRpcDTO> itemInfoMap, List<DemandOrderSaveParamVO.WhStZoObject> whStZoObjects, List<DemandOrderSaveParamVO.ItemObject> itemObjects) {
        if (StrUtil.isNotBlank((CharSequence)headerEntity.getWhStZoCode()) && StrUtil.isNotBlank((CharSequence)headerEntity.getItemCode())) {
            throw new BusinessException("\u4ed3\u5e93/\u95e8\u5e97/\u533a\u57df\u4fe1\u606f\u548c\u5546\u54c1\u4fe1\u606f\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728");
        }
        if (StrUtil.isNotBlank((CharSequence)headerEntity.getWhStZoCode())) {
            DemandOrderSaveParamVO.WhStZoObject whStZoObject = new DemandOrderSaveParamVO.WhStZoObject();
            whStZoObject.setType(this.getTypeByName(headerEntity.getTypeName()));
            whStZoObject.setWhStZoCode(headerEntity.getWhStZoCode());
            whStZoObject.setStoreType(storeTypeMap.get(headerEntity.getWhStZoCode()));
            if ("\u95e8\u5e97".equals(headerEntity.getTypeName())) {
                this.processStore(whStZoObject, storeDataMap);
            } else if ("\u4ed3\u5e93".equals(headerEntity.getTypeName())) {
                this.processWH(whStZoObject, whDataMap);
            } else {
                whStZoObject.setWhStZoName(this.getRegionName(headerEntity.getWhStZoCode()));
            }
            whStZoObjects.add(whStZoObject);
        } else if (StrUtil.isNotBlank((CharSequence)headerEntity.getItemCode())) {
            if (itemInfoMap.containsKey(headerEntity.getItemCode())) {
                if (headerEntity.getDemandQuantity() == null) {
                    throw new BusinessException("\u8ba2\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                BigDecimal qty = SysUtils.processQtyScale(headerEntity.getDemandQuantity());
                ItmItemRpcDTO dto = itemInfoMap.get(headerEntity.getItemCode());
                DemandOrderSaveParamVO.ItemObject itemObject = new DemandOrderSaveParamVO.ItemObject();
                itemObject.setItemId(dto.getId());
                itemObject.setItemCode(dto.getItemCode());
                itemObject.setItemName(dto.getItemName());
                itemObject.setItemCateCode(dto.getItemCateCode());
                itemObject.setItemCateName(dto.getItemCateFullName());
                itemObject.setItemSpec(dto.getSpec());
                itemObject.setBasicUnitMeasure(dto.getUomName());
                itemObject.setWeightUom(dto.getWeightUnit());
                itemObject.setWeightUomName(dto.getWeightUnitName());
                itemObject.setDemandQuantity(qty);
                if (dto.getGrossWeight() != null) {
                    BigDecimal weight = SysUtils.processQtyScale(dto.getGrossWeight());
                    itemObject.setWeight(weight);
                    itemObject.setTotalWeight(SysUtils.processQtyScale(qty.multiply(weight)));
                }
                itemObjects.add(itemObject);
            } else {
                throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            }
        }
    }

    private void processStore(DemandOrderSaveParamVO.WhStZoObject whStZoObject, Map<String, OrgStoreDetailRpcDTO> storeDataMap) {
        String whStZoCode = whStZoObject.getWhStZoCode();
        if (!storeDataMap.containsKey(whStZoCode)) {
            throw new BusinessException("\u6839\u636e\u95e8\u5e97\u7f16\u7801,\u627e\u4e0d\u5230\u95e8\u5e97\u4fe1\u606f");
        }
        OrgStoreDetailRpcDTO dto = storeDataMap.get(whStZoCode);
        whStZoObject.setWhStZoName(dto.getStoreName());
        whStZoObject.setDetailedAddress(dto.getAddressRpcDTO().getDetailAddr());
        whStZoObject.setBelongOrgCode(dto.getPcode());
        whStZoObject.setBelongOrgName(dto.getPname());
        whStZoObject.setBelongOuCode(dto.getOuCode());
        whStZoObject.setBelongOuName(dto.getOuName());
        whStZoObject.setStoreType(dto.getStoreType2());
    }

    private void processWH(DemandOrderSaveParamVO.WhStZoObject whStZoObject, Map<String, InvWhRpcDTO> whDataMap) {
        String whStZoCode = whStZoObject.getWhStZoCode();
        if (!whDataMap.containsKey(whStZoCode)) {
            throw new BusinessException("\u6839\u636e\u4ed3\u5e93\u7f16\u7801,\u627e\u4e0d\u5230\u95e8\u4ed3\u5e93\u606f");
        }
        InvWhRpcDTO dto = whDataMap.get(whStZoCode);
        whStZoObject.setWhStZoName(dto.getWhName());
        whStZoObject.setDetailedAddress(this.appendDetailAddress(dto));
        whStZoObject.setBelongOrgCode(dto.getBelongBuCode());
        whStZoObject.setBelongOrgName(dto.getBelongBuName());
        whStZoObject.setBelongOuCode(dto.getOuCode());
        whStZoObject.setBelongOuName(dto.getOuName());
    }

    private String appendDetailAddress(InvWhRpcDTO dto) {
        return dto.getCountryName() + dto.getProvinceName() + dto.getCityName() + dto.getCountyName() + dto.getDetailaddr();
    }

    private Map<String, ItmItemRpcDTO> ProcessItemInfo(List<String> itemCodeList) {
        if (CollUtil.isEmpty(itemCodeList)) {
            return new HashMap<String, ItmItemRpcDTO>();
        }
        itemCodeList = itemCodeList.stream().distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam rpcParam = new ItmItemRpcDtoParam();
        rpcParam.setItemCodes(itemCodeList);
        List<ItmItemRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemRpcDtoByParam(rpcParam);
        Map<String, ItmItemRpcDTO> itemCodeEntityMap = itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
        log.info("\u5546\u54c1\u4fe1\u606f\u5b57\u5178\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(itemCodeEntityMap));
        return itemCodeEntityMap;
    }

    private String getRegionName(String regionCode) {
        ApiResult result = this.orgRegionRpcService.getNameByCode(regionCode);
        if (StrUtil.isBlank((CharSequence)((CharSequence)result.getData()))) {
            throw new BusinessException("\u6839\u636e\u533a\u57df\u7f16\u7801,\u627e\u4e0d\u5230\u533a\u57df\u4fe1\u606f");
        }
        return (String)result.getData();
    }

    private Integer getTypeByName(String typeName) {
        Map<String, String> templateOrderType = this.rmiSysUDCService.getCodeMap("yst-suplan", "TEMPLATE_ORDER_TYPE");
        Map<String, String> map = templateOrderType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        if (!map.containsKey(typeName)) {
            throw new BusinessException("\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef");
        }
        return Integer.valueOf(map.get(typeName));
    }

    private String getDocTypeName(String docTypeName) {
        Map<String, String> docTypeMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
        Map<String, String> map = docTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        if (!map.containsKey(docTypeName)) {
            throw new BusinessException("\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef");
        }
        return map.get(docTypeName);
    }

    private String getDemandTypeName(String demandTypeName) {
        Map<String, String> docTypeMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "DEMAND_SET_TYPE");
        Map<String, String> map = docTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        if (!map.containsKey(demandTypeName)) {
            throw new BusinessException("\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef");
        }
        return map.get(demandTypeName);
    }

    private Integer getStatusByName(String statusName) {
        if ("\u542f\u7528".equals(statusName)) {
            return 1;
        }
        if ("\u7981\u7528".equals(statusName)) {
            return 0;
        }
        throw new BusinessException("\u72b6\u6001\u5b57\u6bb5\u7ef4\u62a4\u9519\u8bef");
    }

    private void detailedTimeCheck(String detailedTime) {
        if (StrUtil.isBlank((CharSequence)detailedTime)) {
            throw new BusinessException("\u6a21\u677f\u8be6\u60c5\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (!DayOfWeekEnumHelper.validDesc((String)detailedTime)) {
            throw new BusinessException("\u683c\u5f0f\u9519\u8bef\uff0c\u5305\u542b\u975e\u6cd5\u6570\u636e(\u53c2\u8003\u683c\u5f0f:\u5468\u4e00\uff0c\u5468\u4e8c\uff0c\u5468\u4e09\uff0c\u5468\u56db\uff0c\u5468\u4e94\uff0c\u5468\u516d\uff0c\u5468\u65e5)");
        }
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, Integer rowNo, String msg) {
        DemandOrderTemplateImportService.addErrMsg(errMsgMap, Collections.singletonList(rowNo), msg);
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, List<Integer> rowNos, String msg) {
        for (Integer rowNo : rowNos) {
            if (errMsgMap.containsKey(rowNo) && errMsgMap.get(rowNo) != null) {
                String newMsg = errMsgMap.get(rowNo) + LINE + msg;
                errMsgMap.put(rowNo, newMsg);
                continue;
            }
            errMsgMap.put(rowNo, msg);
        }
    }

    public DemandOrderTemplateImportService(DemandOrderTemplateService demandOrderTemplateService, TransactionTemplate transactionTemplate, RmiSysUDCService rmiSysUDCService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiItemService rmiItemService, RmiInvStkRpcService rmiInvStkRpcService, OrgRegionRpcService orgRegionRpcService) {
        this.demandOrderTemplateService = demandOrderTemplateService;
        this.transactionTemplate = transactionTemplate;
        this.rmiSysUDCService = rmiSysUDCService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiItemService = rmiItemService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.orgRegionRpcService = orgRegionRpcService;
    }
}

