/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.job.service;

import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.job.service.ScpDemandSetJobService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.SysUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpDemandSetJobServiceImpl
implements ScpDemandSetJobService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandSetJobServiceImpl.class);
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpStoreDemandCalendarService scpStoreDemandCalendarService;
    private final SysSettingService sysSettingService;

    @Override
    public void autoCreateDemandSet() {
        ScpCalendarStoreQueryParamVO paramVO = new ScpCalendarStoreQueryParamVO();
        paramVO.setWorkStatus(ScpUdcEnum.CALENDAR_WORK_STATUS_W.getValueCode());
        paramVO.setFindDate(LocalDate.now());
        Boolean isExist = this.scpStoreDemandCalendarService.isExistStoreByDateAndWorkStatus(paramVO);
        if (!isExist.booleanValue()) {
            return;
        }
        for (int i = 0; i < 7; ++i) {
            LocalDate demandDate = LocalDate.now().plusDays(i);
            List<ScpDemandSetDTO> scpDemandSetDTOList = this.scpDemandSetDomainService.findDemandSetByParam(ScpDemandSetParamVO.builder().demandDate(demandDate.atStartOfDay()).build());
            Optional<ScpDemandSetDTO> storeType = scpDemandSetDTOList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).findAny();
            if (!storeType.isEmpty()) continue;
            int times = SysUtils.getAutoOrderSetNumSetting();
            for (int n = 0; n < times; ++n) {
                String storeDemandCode = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("BKST", new ArrayList<String>());
                this.saveDemandSet(demandDate.atStartOfDay(), storeDemandCode, ScpUdcEnum.DEMAND_SET_TYPE_0, "\u95e8\u5e97\u8ba2\u8d27\u96c6");
            }
        }
    }

    private void saveDemandSet(LocalDateTime demandDate, String demandCode, ScpUdcEnum demandType, String demandPrefix) {
        ScpDemandSetSaveVO demandSetSaveVO = new ScpDemandSetSaveVO();
        demandSetSaveVO.setDemandCode(demandCode);
        demandSetSaveVO.setType(demandType.getValueCode());
        demandSetSaveVO.setDemandName(demandPrefix + this.convertDate(demandDate) + demandCode.substring(demandCode.length() - 3));
        demandSetSaveVO.setDemandDate(demandDate);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        demandSetSaveVO.setExpireTime(LocalDateTime.of(demandDate.toLocalDate(), LocalTime.parse("13:00:00", formatter)));
        this.scpDemandSetDomainService.saveDemandSet(demandSetSaveVO);
    }

    private String convertDate(LocalDateTime demandDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u53f7");
        return demandDate.format(formatter);
    }

    public ScpDemandSetJobServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, ScpDemandSetDomainService scpDemandSetDomainService, ScpStoreDemandCalendarService scpStoreDemandCalendarService, SysSettingService sysSettingService) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpDemandSetDomainService = scpDemandSetDomainService;
        this.scpStoreDemandCalendarService = scpStoreDemandCalendarService;
        this.sysSettingService = sysSettingService;
    }
}

