/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.item.service.ItmItemBomRpcService;
import com.elitesland.support.provider.pri.service.PriPriceRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmBomPriceRpcDtoParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiPriceRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiPriceRpcService.class);
    private final PriPriceRpcService priPriceRpcService;
    private final ItmItemBomRpcService itmItemBomRpcService;

    public List<PriPriceRpcDTO> findPriceByParam(List<ItmPriPriceRpcDtoParam> paramList) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u65b9\u6cd5,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString(paramList));
        try {
            ApiResult priPrice = this.priPriceRpcService.findPriPrice(paramList);
            log.info("\u8c03\u7528\u652f\u6491\u57df-\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)priPrice));
            if (priPrice != null && priPrice.isSuccess() && CollUtil.isNotEmpty((Collection)((Collection)priPrice.getData()))) {
                List result = (List)priPrice.getData();
                log.info("\u8c03\u7528\u652f\u6491\u57df-\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
                return result;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c:", (Throwable)e);
            throw new BusinessException("\u652f\u6491\u57df\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
        return new ArrayList<PriPriceRpcDTO>();
    }

    public List<PriPriceRpcDTO> findBomPriceByParam(List<ItmBomPriceRpcDtoParam> params) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u83b7\u53d6\u5b50\u4ef6\u5546\u54c1\u4ef7\u683c\u65b9\u6cd5,\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSONObject.toJSONString(params));
        try {
            ApiResult priPrice = this.itmItemBomRpcService.findBomItemPriceByParam(params);
            log.info("\u8c03\u7528\u652f\u6491\u57df-\u83b7\u53d6\u5b50\u4ef6\u5546\u54c1\u4ef7\u683c\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)priPrice));
            if (priPrice != null && priPrice.isSuccess() && CollUtil.isNotEmpty((Collection)((Collection)priPrice.getData()))) {
                List result = (List)priPrice.getData();
                log.info("\u8c03\u7528\u652f\u6491\u57df-\u83b7\u53d6\u5b50\u4ef6\u5546\u54c1\u4ef7\u683c\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
                return result;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5b50\u4ef6\u5546\u54c1\u4ef7\u683c:", (Throwable)e);
            throw new BusinessException("\u652f\u6491\u57df\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
        return new ArrayList<PriPriceRpcDTO>();
    }

    public RmiPriceRpcService(PriPriceRpcService priPriceRpcService, ItmItemBomRpcService itmItemBomRpcService) {
        this.priPriceRpcService = priPriceRpcService;
        this.itmItemBomRpcService = itmItemBomRpcService;
    }
}

