/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.mrp;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpRespVO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDO;
import com.elitesland.scp.domain.service.mrp.ScpMrpDomainService;
import com.elitesland.scp.infr.repo.mrp.ScpMrpRepo;
import com.elitesland.scp.infr.repo.mrp.ScpMrpRepoProc;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMrpDomainServiceImpl
implements ScpMrpDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpMrpDomainServiceImpl.class);
    private final ScpMrpRepo scpMrpRepo;
    private final ScpMrpRepoProc scpMrpRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpMrpRespVO> searchPage(ScpMrpPageParam param) {
        return this.scpMrpRepoProc.pageQuery(param);
    }

    @Override
    public List<ScpMrpDO> findByIds(List<Long> ids) {
        return this.scpMrpRepo.findAllById(ids);
    }

    @Override
    public ScpMrpDO findById(Long id) {
        return this.scpMrpRepo.findById(id).orElse(null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpMrpRepo.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePushStatus(Long id, String pushStatus, String pushFailReason) {
        this.scpMrpRepoProc.updatePushStatus(List.of(id), pushStatus, pushFailReason);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePushStatus(List<Long> ids, String pushStatus, String pushFailReason) {
        this.scpMrpRepoProc.updatePushStatus(ids, pushStatus, pushFailReason);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ScpMrpDO> saveList(List<ScpMrpDO> scpMrpDOs) {
        return this.scpMrpRepo.saveAll(scpMrpDOs);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ScpMrpDO save(ScpMrpDO scpMrpDO) {
        return (ScpMrpDO)this.scpMrpRepo.save(scpMrpDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCalcStatus(List<Long> ids, String calcStatus, String calcFailReason) {
        this.scpMrpRepoProc.updateCalcStatus(ids, calcStatus, calcFailReason);
    }

    public ScpMrpDomainServiceImpl(ScpMrpRepo scpMrpRepo, ScpMrpRepoProc scpMrpRepoProc) {
        this.scpMrpRepo = scpMrpRepo;
        this.scpMrpRepoProc = scpMrpRepoProc;
    }
}

