package com.elitesland.scp.application.facade.vo.resp.wqf;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-02-27
* @Version 1.0
**/

@Data
@ApiModel("微企付开户申请分页列表")
public class ScpWqfEntAccountApplyPageParam extends AbstractOrderQueryParam {

    @ApiModelProperty(value = "申请单号")
    private String docNo;

    @ApiModelProperty(value = "公司ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    @ApiModelProperty(value = "公司商户号")
    private String entId;

    @ApiModelProperty(value = "申请状态")
    private String applyStatus;
    private String applyStatusName;

    @ApiModelProperty(value = "门店ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> storeIds;

    @ApiModelProperty(value = "门店商户号")
    private String entAcctId;




}