package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSaveVO;
import com.elitesland.scp.infr.dto.calendar.ScpStoreCalendarSetDTO;
import com.elitesland.workflow.enums.ProcInstStatus;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

public interface ScpStoreCalendarSetDomainService {

    /**
     * 门店订货日历配置查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpStoreCalendarSetPageRespVO> queryCalendarSetList(ScpStoreCalendarSetPageParamVO paramVO);

    /**
     * 门店订货日历配置详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpStoreCalendarSetDTO> findCalendarSetById(Long id);

    /**
     * 门店订货日历配置保存
     *
     * @param saveVO 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    Long saveCalendarSet(ScpStoreCalendarSetSaveVO saveVO);

    /**
     * 删除门店订货日历配置
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 查询门店订货日历配置总数
     *
     * @param paramVO
     * @return
     */
    List<ScpStoreCalendarSetRespVO> findCalendarSet(ScpStoreCalendarSetParamVO paramVO);

    /**
     * 审批
     *
     * @param ids
     * @param docStatus
     * @param procInstStatus
     * @param approveComment
     * @param apprTime
     */
    void approveUpdateApplyAlter(List<Long> ids, String docStatus, ProcInstStatus procInstStatus,
                                 String approveComment, LocalDateTime apprTime);

    void applyChangeUpdate(Long id, String docStatus, ProcInstStatus procInstStatus);
}
