package com.elitesland.scp.infr.repo.serviceconfig;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigExportRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigPageParamVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigPageVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.domain.entity.serviceconfig.QScpServiceConfigDO;
import com.elitesland.scp.domain.entity.serviceconfig.ScpServiceConfigDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.Expressions;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author chaofeng.xia
 * @since 2025/5/26
 */
@Component
public class ScpServiceConfigRepoProc extends BaseRepoProc<ScpServiceConfigDO> {

    private static final QScpServiceConfigDO serviceConfigDO = QScpServiceConfigDO.scpServiceConfigDO;

    public ScpServiceConfigRepoProc() {
        super(serviceConfigDO);
    }


    public PagingVO<ScpServiceConfigPageVO> page(ScpServiceConfigPageParamVO param) {
        val jpaQuery = jpaQueryFactory.select(getBean()).from(serviceConfigDO);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return queryByPage(jpaQuery, param.getPageRequest());
    }


    @NotNull
    private QBean<ScpServiceConfigPageVO> getBean() {
        return Projections.bean(
                ScpServiceConfigPageVO.class,
                serviceConfigDO.id,
                serviceConfigDO.feeType,
                serviceConfigDO.ouId,
                serviceConfigDO.ouCode,
                serviceConfigDO.ouName,
                serviceConfigDO.type,
                serviceConfigDO.regionStoreId,
                serviceConfigDO.regionStoreCode,
                serviceConfigDO.regionStoreName,
                serviceConfigDO.storeLevel,
                serviceConfigDO.feePercentage,
                serviceConfigDO.businessKey,
                serviceConfigDO.type,
                serviceConfigDO.createTime,
                serviceConfigDO.createUserId,
                serviceConfigDO.creator,
                serviceConfigDO.modifyUserId,
                serviceConfigDO.modifyTime,
                serviceConfigDO.updater,
                serviceConfigDO.remark,
                serviceConfigDO.tenantId

        );
    }

    private Predicate where(ScpServiceConfigPageParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (CollectionUtils.isNotEmpty(param.getIdSet())) {
            predicate = ExpressionUtils.and(predicate, serviceConfigDO.id.in(param.getIdSet()));
        }
        if (CollectionUtils.isNotEmpty(param.getFeeTypes())) {
            predicate = ExpressionUtils.and(predicate, serviceConfigDO.feeType.in(param.getFeeTypes()));
        }
        if (param.getOuId() != null) {
            predicate = ExpressionUtils.and(predicate, serviceConfigDO.ouId.eq(param.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getTypes())) {
            predicate = ExpressionUtils.and(predicate, serviceConfigDO.type.in(param.getTypes()));
        }
        if (StringUtils.isNotEmpty(param.getType())) {
            predicate = ExpressionUtils.and(predicate, serviceConfigDO.type.eq(param.getType()));
        }
        if (CollectionUtils.isNotEmpty(param.getRegionStoreIds())) {
            predicate = ExpressionUtils.and(predicate, serviceConfigDO.regionStoreId.in(param.getRegionStoreIds()));
        }
        return predicate;

    }

    public PagingVO<ScpServiceConfigExportRespVO> exportSearch(ScpServiceConfigPageParamVO param) {
        val jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpServiceConfigExportRespVO.class,
                serviceConfigDO.id,
                serviceConfigDO.feeType,
                serviceConfigDO.ouId,
                serviceConfigDO.ouCode,
                serviceConfigDO.ouName,
                serviceConfigDO.type,
                serviceConfigDO.regionStoreId,
                serviceConfigDO.regionStoreCode,
                serviceConfigDO.regionStoreName,
                serviceConfigDO.storeLevel,
                serviceConfigDO.feePercentage,
                serviceConfigDO.businessKey,
                serviceConfigDO.type,
                serviceConfigDO.createTime,
                serviceConfigDO.createUserId,
                serviceConfigDO.creator,
                serviceConfigDO.modifyUserId,
                serviceConfigDO.modifyTime,
                serviceConfigDO.updater,
                serviceConfigDO.remark,
                serviceConfigDO.tenantId
        )).from(serviceConfigDO);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return queryByPage(jpaQuery, param.getPageRequest());
    }

    public List<ScpServiceConfigRespVO> findByStoreCode(String storeCode){
        return jpaQueryFactory.select(Projections.bean(
                ScpServiceConfigRespVO.class,
                serviceConfigDO.id,
                serviceConfigDO.feeType,
                serviceConfigDO.ouCode,
                serviceConfigDO.ouName,
                serviceConfigDO.type,
                serviceConfigDO.regionStoreCode,
                serviceConfigDO.feePercentage,
                serviceConfigDO.storeLevel
        )).from(serviceConfigDO).where(serviceConfigDO.regionStoreCode.eq(storeCode)
                .and(serviceConfigDO.type.eq("STORE")).and(serviceConfigDO.deleteFlag.eq(0)
                        .or(serviceConfigDO.deleteFlag.isNull()))).fetch();
    }

    public List<ScpServiceConfigRespVO> findByRegionCode(String regionCode,String level){
        return jpaQueryFactory.select(Projections.bean(
                ScpServiceConfigRespVO.class,
                serviceConfigDO.id,
                serviceConfigDO.feeType,
                serviceConfigDO.ouCode,
                serviceConfigDO.ouName,
                serviceConfigDO.type,
                serviceConfigDO.regionStoreCode,
                serviceConfigDO.feePercentage,
                serviceConfigDO.storeLevel
        )).from(serviceConfigDO).where(serviceConfigDO.regionStoreCode.eq(regionCode)
                .and(serviceConfigDO.type.eq("REGION"))
                .and(serviceConfigDO.deleteFlag.eq(0)
                        .or(serviceConfigDO.deleteFlag.isNull()))
                .and(serviceConfigDO.storeLevel.eq(level))).fetch();
    }

    public List<ScpServiceConfigRespVO> findByRegionCode2(String regionCode,String level,List<String> freeTypes){
        return jpaQueryFactory.select(Projections.bean(
                ScpServiceConfigRespVO.class,
                serviceConfigDO.id,
                serviceConfigDO.feeType,
                serviceConfigDO.ouCode,
                serviceConfigDO.ouName,
                serviceConfigDO.type,
                serviceConfigDO.regionStoreCode,
                serviceConfigDO.feePercentage,
                serviceConfigDO.storeLevel
        )).from(serviceConfigDO).where(serviceConfigDO.regionStoreCode.eq(regionCode)
                .and(serviceConfigDO.type.eq("REGION"))
                .and(serviceConfigDO.deleteFlag.eq(0)
                        .or(serviceConfigDO.deleteFlag.isNull()))
                .and(serviceConfigDO.storeLevel.eq(level))
                .and(serviceConfigDO.feeType.in(freeTypes))
        ).fetch();
    }
}