package com.elitesland.scp.application.facade.vo.param.collect;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel("收藏取消入参")
public class ScpUserCollectCancelVO implements Serializable {
    private static final long serialVersionUID = -1267669052567414864L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty("商品SPU_ID")
    @NotNull(message = "商品SPU_ID不能为空")
    private Long spuId;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("商品编码")
    private String itemCode;
}
