package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingStoreSaveVO;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingStoreConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingStoreDO;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingStoreRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingStoreRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpMinOrderSettingStoreDomainServiceImpl implements ScpMinOrderSettingStoreDomainService {
    private final EntityManager entityManager;
    private final ScpMinOrderSettingStoreRepo scpMinOrderSettingStoreRepo;
    private final ScpMinOrderSettingStoreRepoProc scpMinOrderSettingStoreRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpMinOrderSettingStoreRespVO> page(ScpMinOrderSettingStorePageParamVO paramVO) {
        long count = scpMinOrderSettingStoreRepoProc.countMinOrderSettingStore(paramVO);
        if (count > 0) {
            List<ScpMinOrderSettingStoreRespVO> storeRespVOList = scpMinOrderSettingStoreRepoProc.queryMinOrderSettingStore(paramVO);
            return new PagingVO<>(count, storeRespVOList);
        }
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveMinOrderSettingStore(List<ScpMinOrderSettingStoreSaveVO> saveVOS, int batchSize) {
        this.batchInsert(ScpMinOrderSettingStoreConvert.INSTANCE.saveVosDOS(saveVOS), batchSize);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpMinOrderSettingStoreRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpMinOrderSettingStoreRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByStoreCode(String storeCode) {
        return scpMinOrderSettingStoreRepoProc.findMasIdByStoreCode(storeCode);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMinOrderNumByParam(List<Long> masIds, String storeCode) {
        scpMinOrderSettingStoreRepo.updateActiveNumByParam(masIds, storeCode);
    }

    @Override
    public List<ScpMinOrderSettingStoreRespVO> findByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        return scpMinOrderSettingStoreRepoProc.findByParam(paramVO);
    }

    @Override
    public Long updateMinOrderSettingStore(ScpMinOrderSettingStoreSaveVO saveVO) {
        Optional<ScpMinOrderSettingStoreDO> option = scpMinOrderSettingStoreRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("订货强配门店ID：" + saveVO.getId() + "不存在");
        }
        ScpMinOrderSettingStoreDO scpMinOrderSettingDO = option.get();
        ScpMinOrderSettingStoreConvert.INSTANCE.copySaveParamToDo(saveVO, scpMinOrderSettingDO);
        return scpMinOrderSettingStoreRepo.save(scpMinOrderSettingDO).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpMinOrderSettingStoreRespVO> findByMasId(Long masId) {
        List<ScpMinOrderSettingStoreDO> settingStoreDOS = scpMinOrderSettingStoreRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingStoreDOS)) {
            return ScpMinOrderSettingStoreConvert.INSTANCE.dosToRespVOS(settingStoreDOS);
        }
        return new ArrayList<>();
    }

    @Override
    public List<ScpMinOrderSettingStoreRespVO> findEnabledByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        return scpMinOrderSettingStoreRepoProc.findEnabledByParam(paramVO);
    }

    public void batchInsert(List<ScpMinOrderSettingStoreDO> dataList, int batchSize) {
        int index = 0;
        for (ScpMinOrderSettingStoreDO data : dataList) {
            entityManager.persist(data);
            if (batchSize > 1) {
                // 开启批量
                index++;
                if (index % batchSize == 0) {
                    entityManager.flush();
                    entityManager.clear();
                }
            }
        }
        if (!dataList.isEmpty()) {
            entityManager.flush();
        }
    }
}
