package com.elitesland.scp.utils;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetComputeParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
public class CalendarBuilder {

    private static final Map<Integer, List<ScpStoreCalendarSetLineRespVO>> DAY_MAP = new HashMap<>();
    private static final Map<Integer, List<ScpStoreCalendarSetLineRespVO>> NO_DAY_MAP = new HashMap<>();

    static {
        DAY_MAP.put(1, new ArrayList<>());
        DAY_MAP.put(2, new ArrayList<>());
        DAY_MAP.put(3, new ArrayList<>());
        DAY_MAP.put(4, new ArrayList<>());
        DAY_MAP.put(5, new ArrayList<>());
        DAY_MAP.put(6, new ArrayList<>());
        DAY_MAP.put(7, new ArrayList<>());
    }

    static {
        NO_DAY_MAP.put(1, new ArrayList<>());
        NO_DAY_MAP.put(2, new ArrayList<>());
        NO_DAY_MAP.put(3, new ArrayList<>());
        NO_DAY_MAP.put(4, new ArrayList<>());
        NO_DAY_MAP.put(5, new ArrayList<>());
        NO_DAY_MAP.put(6, new ArrayList<>());
        NO_DAY_MAP.put(7, new ArrayList<>());
    }

    public static List<ScpStoreDemandCalendarDO> buildCalendarSetList(LocalDate startOfYear, LocalDate endOfYear, ScpStoreCalendarSetComputeParamVO param, String deliveryType, String type) {
        try {
            // 初始化星期几的映射
            DAY_MAP.put(1, param.getMonList());
            DAY_MAP.put(2, param.getTuesList());
            DAY_MAP.put(3, param.getWendsList());
            DAY_MAP.put(4, param.getThursList());
            DAY_MAP.put(5, param.getFriList());
            DAY_MAP.put(6, param.getSaturList());
            DAY_MAP.put(7, param.getSunList());

            NO_DAY_MAP.put(1, param.getNonMonList());
            NO_DAY_MAP.put(2, param.getNonTuesList());
            NO_DAY_MAP.put(3, param.getNonWendsList());
            NO_DAY_MAP.put(4, param.getNonThursList());
            NO_DAY_MAP.put(5, param.getNonFriList());
            NO_DAY_MAP.put(6, param.getNonSaturList());
            NO_DAY_MAP.put(7, param.getNonSunList());

            List<ScpStoreDemandCalendarDO> saveList = new ArrayList<>();
            while (!startOfYear.isAfter(endOfYear)) {
                // 获取当前日期的星期几
                int dayOfWeekValue = startOfYear.getDayOfWeek().getValue();
                // 获取当前日期的星期几对应的日历设置列表
                List<ScpStoreCalendarSetLineRespVO> dayList = DAY_MAP.get(dayOfWeekValue);
                // 获取当前日期的星期几对应的非日历设置列表
                List<ScpStoreCalendarSetLineRespVO> nonDayList = NO_DAY_MAP.get(dayOfWeekValue);

                if (CollUtil.isNotEmpty(dayList)) {
                    // 如果日历设置列表不为空，则遍历列表，将日历设置添加到保存列表中
                    for (ScpStoreCalendarSetLineRespVO line : dayList) {
                        //要求根据类型再次拆分，保证每个数据只有一个类型
                        String []deliveryTypeList = deliveryType.split(",");
                        for (String typeStr : deliveryTypeList) {
                            ScpStoreCalendarSetLineRespVO lineCopy = new ScpStoreCalendarSetLineRespVO();
                            BeanUtils.copyProperties(line, lineCopy); // 使用Spring的BeanUtils复制属性
                            lineCopy.setDeliveryType(typeStr);
                            lineCopy.setType(type);
                            saveList.add(buildCalendarSet(lineCopy, startOfYear, "W"));
                        }
                    }
                }
                if (CollUtil.isNotEmpty(nonDayList)) {
                    // 如果非日历设置列表不为空，则遍历列表，将非日历设置添加到保存列表中
                    for (ScpStoreCalendarSetLineRespVO line : nonDayList) {
                        //要求根据类型再次拆分，保证每个数据只有一个类型
                        String []deliveryTypeList = deliveryType.split(",");
                        for (String typeStr : deliveryTypeList) {
                            ScpStoreCalendarSetLineRespVO lineCopy = new ScpStoreCalendarSetLineRespVO();
                            BeanUtils.copyProperties(line, lineCopy); // 使用Spring的BeanUtils复制属性
                            lineCopy.setDeliveryType(typeStr);
                            lineCopy.setType(type);
                            saveList.add(buildCalendarSet(lineCopy, startOfYear, "E"));
                        }
                    }
                }
                // 将当前日期加1天
                startOfYear = startOfYear.plusDays(1);
            }
            return saveList;
            // 处理 saveList，例如保存到数据库等
        } catch (Exception e) {
            // 记录日志或处理异常
            log.error("处理日历设置列表时发生错误:{}", e.getMessage(), e);
        }
        return new ArrayList<>();
    }

    private static ScpStoreDemandCalendarDO buildCalendarSet(ScpStoreCalendarSetLineRespVO line, LocalDate date, String workStatus) {
        ScpStoreDemandCalendarDO saveDO = new ScpStoreDemandCalendarDO();
        saveDO.setStoreId(line.getStoreId());
        saveDO.setStoreCode(line.getStoreCode());
        saveDO.setStoreName(line.getStoreName());
        saveDO.setYear(String.valueOf(date.getYear()));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
        String month = date.format(formatter);
        saveDO.setMonth(month); // 修改为获取月份值
        saveDO.setDay(String.valueOf(date.getDayOfMonth()));
        saveDO.setWorkStatus(workStatus);
        saveDO.setType(line.getType());
        saveDO.setDeliveryType(line.getDeliveryType());
        return saveDO;
    }
}

