/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingItemSaveVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingRegionSaveVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingSaveVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingStoreSaveVO;
import com.elitesland.scp.application.service.purLimit.ScpPurLimitSettingService;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingDO;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingRedisDO;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingDomainService;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingItemDomainService;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingRegionDomainService;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingStoreDomainService;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRepo;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.dto.SpuImageDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBasePageRpcParam;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpPurLimitSettingServiceImpl
implements ScpPurLimitSettingService {
    private static final Logger log = LoggerFactory.getLogger(ScpPurLimitSettingServiceImpl.class);
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpPurLimitSettingDomainService scpPurLimitSettingDomainService;
    private final ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService;
    private final ScpPurLimitSettingRegionDomainService scpPurLimitSettingRegionDomainService;
    private final ScpPurLimitSettingStoreDomainService scpPurLimitSettingStoreDomainService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RedisTemplate<String, Object> redisClient;
    private final ScpPurLimitSettingRepo scpPurLimitSettingRepo;
    private final RmiItemService rmiItemService;
    private final RmiSysUDCService rmiSysUDCService;

    private static void checkParam(ScpPurLimitSettingSaveVO saveVO) {
        if (CollUtil.isEmpty(saveVO.getRegionList())) {
            throw new BusinessException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(saveVO.getItemList())) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public PagingVO<ScpPurLimitSettingPageRespVO> page(ScpPurLimitSettingPageParamVO paramVO) {
        HashSet<Long> masIds = new HashSet<Long>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getRegion())) {
            List<Long> regionMasIds = this.scpPurLimitSettingRegionDomainService.findMasIdByRegionCode(paramVO.getRegion());
            if (CollUtil.isEmpty(regionMasIds)) {
                return new PagingVO();
            }
            masIds.addAll(regionMasIds);
        }
        if (paramVO.getStoreCode() != null) {
            List<Long> storeMasIds = this.scpPurLimitSettingStoreDomainService.findMasIdByStoreCode(paramVO.getStoreCode());
            if (CollUtil.isEmpty(storeMasIds)) {
                return new PagingVO();
            }
            this.intersectSets(masIds, storeMasIds);
        }
        if (paramVO.getItemId() != null) {
            List<Long> itemMasIds = this.scpPurLimitSettingItemDomainService.findMasIdByItemId(paramVO.getItemId());
            if (CollUtil.isEmpty(itemMasIds)) {
                return new PagingVO();
            }
            this.intersectSets(masIds, itemMasIds);
        }
        paramVO.setIds(new ArrayList<Long>(masIds));
        return this.scpPurLimitSettingDomainService.queryPurLimitSettingList(paramVO);
    }

    @Override
    @SysCodeProc
    public ScpPurLimitSettingRespVO findPurLimitSettingById(Long id) {
        Optional<ScpPurLimitSettingRespVO> scpPurLimitSettingRespVO = this.scpPurLimitSettingDomainService.findPurLimitSettingById(id).map(ScpPurLimitSettingConvert.INSTANCE::dtoToRespVO);
        if (scpPurLimitSettingRespVO.isPresent()) {
            ScpPurLimitSettingRespVO PurLimitSettingRespVO = scpPurLimitSettingRespVO.get();
            PurLimitSettingRespVO.setAllStoreFlag(Boolean.FALSE);
            PurLimitSettingRespVO.setItemRespVOList(this.scpPurLimitSettingItemDomainService.findByMasId(id));
            PurLimitSettingRespVO.setRegionRespVOList(this.scpPurLimitSettingRegionDomainService.findByMasId(id));
            PurLimitSettingRespVO.setStoreRespVOList(this.scpPurLimitSettingStoreDomainService.findByMasId(id));
            if (StrUtil.isNotBlank((CharSequence)PurLimitSettingRespVO.getDocType())) {
                PurLimitSettingRespVO.setDocTypes(StrUtil.split((CharSequence)PurLimitSettingRespVO.getDocType(), (char)','));
            }
            return PurLimitSettingRespVO;
        }
        return new ScpPurLimitSettingRespVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long savePurLimitSetting(ScpPurLimitSettingSaveVO saveVO) {
        ScpPurLimitSettingServiceImpl.checkParam(saveVO);
        if (saveVO.getId() == null) {
            if (CollUtil.isEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
                throw new BusinessException("\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String orderNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("FA", new ArrayList<String>());
            saveVO.setActivityCode(orderNo);
        } else {
            ScpPurLimitSettingStoreParamVO scpPurLimitSettingStoreParamVO = new ScpPurLimitSettingStoreParamVO();
            scpPurLimitSettingStoreParamVO.setMasIds(List.of(saveVO.getId()));
            scpPurLimitSettingStoreParamVO.setUsed(Boolean.TRUE);
            List<ScpPurLimitSettingStoreRespVO> byParam = this.scpPurLimitSettingStoreDomainService.findByParam(scpPurLimitSettingStoreParamVO);
            if (CollUtil.isNotEmpty(byParam)) {
                throw new BusinessException("\u6d3b\u52a8\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
        }
        Long masId = this.scpPurLimitSettingDomainService.savePurLimitSetting(saveVO);
        this.scpPurLimitSettingItemDomainService.deleteByMasId(masId);
        this.scpPurLimitSettingRegionDomainService.deleteByMasId(masId);
        saveVO.getRegionList().forEach(row -> row.setMasId(masId));
        this.scpPurLimitSettingRegionDomainService.batchSaveSettingRegion(saveVO.getRegionList());
        List itemCodes = saveVO.getItemList().stream().map(ScpPurLimitSettingItemSaveVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodes);
        List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
        saveVO.getItemList().forEach(row -> {
            row.setMasId(masId);
            if (itemRpcDTOMap.containsKey(row.getItemCode())) {
                row.setItemId(((ItmItemRpcDTO)itemRpcDTOMap.get(row.getItemCode())).getId());
            }
        });
        this.scpPurLimitSettingItemDomainService.batchSavePurLimitSettingItem(saveVO.getItemList());
        this.scpPurLimitSettingStoreDomainService.deleteByMasId(masId);
        if (CollUtil.isNotEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
            saveVO.getStoreList().forEach(row -> {
                row.setMasId(masId);
                row.setId(null);
            });
            this.scpPurLimitSettingStoreDomainService.batchSavePurLimitSettingStore(saveVO.getStoreList());
            this.refreshRedisValue(saveVO, masId, saveVO.getStoreList(), itemRpcDTOMap);
        }
        if (CollUtil.isEmpty(saveVO.getStoreList()) && saveVO.getAllStoreFlag().booleanValue()) {
            this.saveDefaultStore(saveVO, masId, itemRpcDTOMap);
        }
        String key = "SCP:PUR_LIMIT:SETTING:" + masId;
        if (!LocalDateTime.now().isAfter(saveVO.getValidTo())) {
            long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), saveVO.getValidTo());
            LocalDateTime validFrom = saveVO.getValidFrom();
            String jsonString = JSON.toJSONString((Object)validFrom);
            this.redisClient.opsForValue().set((Object)key, (Object)jsonString, between, TimeUnit.MINUTES);
        }
        this.scpPurLimitSettingDomainService.enablePurLimitSetting(List.of(masId), Boolean.TRUE);
        return masId;
    }

    private void refreshRedisValue(ScpPurLimitSettingSaveVO saveVO, Long masId, List<ScpPurLimitSettingStoreSaveVO> storeList, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
        ArrayList<ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO>();
        for (ScpPurLimitSettingItemSaveVO item : saveVO.getItemList()) {
            ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO();
            innerItemDO.setItemCode(item.getItemCode());
            innerItemDO.setMasId(masId);
            innerItemDO.setMinNum(item.getMinNum());
            innerItemDO.setItemType2(item.getItemType2());
            if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = itemRpcDTOMap.get(item.getItemCode());
                List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                    Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                    innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                }
                innerItemDO.setItemId(itmItemRpcDTO.getId());
                innerItemDO.setItemName(itmItemRpcDTO.getItemName());
            }
            innerItemDOS.add(innerItemDO);
        }
        for (ScpPurLimitSettingStoreSaveVO store : storeList) {
            ScpPurLimitSettingRedisDO scpPurLimitSettingRedisDO = new ScpPurLimitSettingRedisDO();
            Object obj = this.redisClient.opsForValue().get((Object)("SCP:PUR_LIMIT:SETTING:" + store.getStoreCode()));
            if (obj == null) {
                ScpPurLimitSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                scpPurLimitSettingRedisDO.setActivityList(List.of(activityDO1));
            } else {
                String str = (String)obj;
                ScpPurLimitSettingRedisDO setting = (ScpPurLimitSettingRedisDO)JSON.parseObject((String)str, ScpPurLimitSettingRedisDO.class);
                List<ScpPurLimitSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
                Boolean flag = Boolean.FALSE;
                for (ScpPurLimitSettingRedisDO.ActivityDO inActivityDO : activityList) {
                    if (!inActivityDO.getActivityId().equals(masId)) continue;
                    inActivityDO.setActivityId(masId);
                    inActivityDO.setActivityCode(saveVO.getActivityCode());
                    inActivityDO.setDocTypes(saveVO.getDocTypes());
                    inActivityDO.setMaxNum(store.getMaxNum());
                    inActivityDO.setActiveNum(0);
                    inActivityDO.setValidTo(saveVO.getValidTo());
                    inActivityDO.setValidFrom(saveVO.getValidFrom());
                    inActivityDO.setInnerItemDOS(innerItemDOS);
                    flag = Boolean.TRUE;
                }
                if (!flag.booleanValue()) {
                    ScpPurLimitSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                    activityList.add(activityDO1);
                }
                scpPurLimitSettingRedisDO.setActivityList(activityList);
            }
            String key = "SCP:PUR_LIMIT:SETTING:" + store.getStoreCode();
            redisMap.put((CallSite)((Object)key), JSONUtil.toJsonStr((Object)scpPurLimitSettingRedisDO));
        }
        this.redisClient.opsForValue().multiSet(redisMap);
    }

    private ScpPurLimitSettingRedisDO.ActivityDO createActivityDO(Long masId, ScpPurLimitSettingSaveVO saveVO, ScpPurLimitSettingStoreSaveVO store, List<ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS) {
        ScpPurLimitSettingRedisDO.ActivityDO activityDO = new ScpPurLimitSettingRedisDO.ActivityDO();
        activityDO.setInnerItemDOS(innerItemDOS);
        activityDO.setActivityId(masId);
        activityDO.setActivityCode(saveVO.getActivityCode());
        activityDO.setDocTypes(saveVO.getDocTypes());
        activityDO.setMaxNum(store.getMaxNum());
        activityDO.setActiveNum(0);
        activityDO.setValidFrom(saveVO.getValidFrom());
        activityDO.setValidTo(saveVO.getValidTo());
        return activityDO;
    }

    private void saveDefaultStore(ScpPurLimitSettingSaveVO saveVO, Long masId, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        List regionList = saveVO.getRegionList().stream().map(ScpPurLimitSettingRegionSaveVO::getRegion).distinct().collect(Collectors.toList());
        OrgStoreBasePageRpcParam orgStoreBasePageRpcParam = new OrgStoreBasePageRpcParam();
        orgStoreBasePageRpcParam.setRegionList(regionList);
        Long count = this.rmiOrgStoreRpcService.countBaseStoreByParam(orgStoreBasePageRpcParam);
        if (count == null || count == 0L) {
            log.info("saveDefaultStore\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u95e8\u5e97\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        int totalPage = PageUtil.totalPage((long)count, (int)1000);
        for (int i = 1; i <= totalPage; ++i) {
            orgStoreBasePageRpcParam.setSize(Integer.valueOf(1000));
            orgStoreBasePageRpcParam.setCurrent(Integer.valueOf(i));
            PagingVO<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOPagingVO = this.rmiOrgStoreRpcService.queryBaseStore(orgStoreBasePageRpcParam);
            List<ScpPurLimitSettingStoreSaveVO> storeSaveVOS = orgStoreBaseRpcDTOPagingVO.getRecords().stream().map(row -> {
                ScpPurLimitSettingStoreSaveVO scpPurLimitSettingStoreSaveVO = new ScpPurLimitSettingStoreSaveVO();
                scpPurLimitSettingStoreSaveVO.setStoreId(row.getId());
                scpPurLimitSettingStoreSaveVO.setStoreCode(row.getStoreCode());
                scpPurLimitSettingStoreSaveVO.setStoreName(row.getStoreName());
                scpPurLimitSettingStoreSaveVO.setStoreType2(row.getStoreType2());
                scpPurLimitSettingStoreSaveVO.setMasId(masId);
                scpPurLimitSettingStoreSaveVO.setMaxNum(saveVO.getMaxNum());
                return scpPurLimitSettingStoreSaveVO;
            }).collect(Collectors.toList());
            this.scpPurLimitSettingStoreDomainService.batchSavePurLimitSettingStore(storeSaveVOS, 1000);
            this.refreshRedisValue(saveVO, masId, storeSaveVOS, itemRpcDTOMap);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpPurLimitSettingDomainService.deleteByIds(ids);
        List keys = ids.stream().map(row -> "SCP:PUR_LIMIT:SETTING:" + row).collect(Collectors.toList());
        this.redisClient.delete(keys);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePurLimitSettingStatus(ScpPurLimitSettingStatusParamVO paramVO) {
        if (Boolean.TRUE.equals(paramVO.getStatus())) {
            ScpPurLimitSettingStoreParamVO scpPurLimitSettingStoreParamVO = new ScpPurLimitSettingStoreParamVO();
            scpPurLimitSettingStoreParamVO.setMasIds(paramVO.getIds());
            List<ScpPurLimitSettingStoreRespVO> storeRespVOList = this.scpPurLimitSettingStoreDomainService.findByParam(scpPurLimitSettingStoreParamVO);
            if (CollUtil.isEmpty(storeRespVOList)) {
                throw new BusinessException("\u95e8\u5e97\u4fe1\u606f\u672a\u7ef4\u62a4");
            }
            List<ScpPurLimitSettingDO> settingDOS = this.scpPurLimitSettingRepo.findByIdIn(paramVO.getIds());
            for (ScpPurLimitSettingDO settingDO : settingDOS) {
                String key = "SCP:PUR_LIMIT:SETTING:" + settingDO.getId();
                if (LocalDateTime.now().isAfter(settingDO.getValidTo())) continue;
                long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), settingDO.getValidTo());
                LocalDateTime validFrom = settingDO.getValidFrom();
                String jsonString = JSON.toJSONString((Object)validFrom);
                this.redisClient.opsForValue().set((Object)key, (Object)jsonString, between, TimeUnit.MINUTES);
                List<ScpPurLimitSettingItemRespVO> itemList = this.scpPurLimitSettingItemDomainService.findByMasId(settingDO.getId());
                List itemCodes = itemList.stream().map(ScpPurLimitSettingItemRespVO::getItemCode).distinct().collect(Collectors.toList());
                ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
                Map itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
                ArrayList<ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO>();
                for (ScpPurLimitSettingItemRespVO item : itemList) {
                    ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO();
                    innerItemDO.setItemCode(item.getItemCode());
                    innerItemDO.setMasId(settingDO.getId());
                    innerItemDO.setMinNum(item.getMinNum());
                    innerItemDO.setItemType2(item.getItemType2());
                    if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                        ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemRpcDTOMap.get(item.getItemCode());
                        List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                        if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                            Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                            innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                        }
                        innerItemDO.setItemId(itmItemRpcDTO.getId());
                        innerItemDO.setItemName(itmItemRpcDTO.getItemName());
                    }
                    innerItemDOS.add(innerItemDO);
                }
                HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
                for (ScpPurLimitSettingStoreRespVO store : storeRespVOList) {
                    ScpPurLimitSettingRedisDO scpPurLimitSettingRedisDO = new ScpPurLimitSettingRedisDO();
                    Object obj = this.redisClient.opsForValue().get((Object)("SCP:PUR_LIMIT:SETTING:" + store.getStoreCode()));
                    if (obj != null) continue;
                    ScpPurLimitSettingRedisDO.ActivityDO activityDO1 = new ScpPurLimitSettingRedisDO.ActivityDO();
                    activityDO1.setActivityId(settingDO.getId());
                    activityDO1.setActivityCode(settingDO.getActivityCode());
                    activityDO1.setDocTypes(StrUtil.split((CharSequence)settingDO.getDocType(), (CharSequence)","));
                    activityDO1.setMaxNum(store.getMaxNum());
                    activityDO1.setActiveNum(0);
                    activityDO1.setInnerItemDOS(innerItemDOS);
                    activityDO1.setValidFrom(settingDO.getValidFrom());
                    activityDO1.setValidTo(settingDO.getValidTo());
                    scpPurLimitSettingRedisDO.setActivityList(List.of(activityDO1));
                    String storeKey = "SCP:PUR_LIMIT:SETTING:" + store.getStoreCode();
                    String jsonString2 = JSON.toJSONString((Object)scpPurLimitSettingRedisDO);
                    log.info("\u5199\u5165\u7f13\u5b58\uff1a{}", (Object)jsonString2);
                    redisMap.put((CallSite)((Object)storeKey), jsonString2);
                }
                if (!CollUtil.isNotEmpty(redisMap)) continue;
                this.redisClient.opsForValue().multiSet(redisMap);
            }
        } else {
            List keys = paramVO.getIds().stream().map(row -> "SCP:PUR_LIMIT:SETTING:" + row).collect(Collectors.toList());
            this.redisClient.delete(keys);
        }
        this.scpPurLimitSettingDomainService.enablePurLimitSetting(paramVO.getIds(), paramVO.getStatus());
    }

    @Override
    public List<ScpPurLimitSettingStoreRespVO> importStoreData(List<ScpPurLimitSettingImportStoreParamVO> list) {
        if (CollectionUtil.isEmpty(list)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        for (int i = 0; i < list.size(); ++i) {
            int row = i + 3;
            ScpPurLimitSettingImportStoreParamVO importData = list.get(i);
            if (!StrUtil.isBlank((CharSequence)importData.getStoreCode())) continue;
            throw new BusinessException("\u7b2c" + row + "\u884c\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
        }
        List<String> storeCodes = list.stream().map(ScpPurLimitSettingImportStoreParamVO::getStoreCode).distinct().toList();
        List<OrgStoreBaseRpcDTO> orgStoreBaseByParam = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(storeCodes);
        Map<Object, Object> storeBaseMap = CollUtil.isNotEmpty(orgStoreBaseByParam) ? orgStoreBaseByParam.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (key, value) -> value)) : new HashMap();
        Map<String, String> storeType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "STORE_TYPE2");
        ArrayList<ScpPurLimitSettingStoreRespVO> res = new ArrayList<ScpPurLimitSettingStoreRespVO>();
        for (int i = 0; i < list.size(); ++i) {
            int row = i + 3;
            ScpPurLimitSettingImportStoreParamVO l = list.get(i);
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)storeBaseMap.get(l.getStoreCode());
            if (orgStoreBaseRpcDTO == null) {
                throw new BusinessException("\u7b2c" + row + "\u884c\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            ScpPurLimitSettingStoreRespVO applyDResp = new ScpPurLimitSettingStoreRespVO();
            applyDResp.setStoreId(orgStoreBaseRpcDTO.getId());
            applyDResp.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            applyDResp.setStoreName(orgStoreBaseRpcDTO.getStoreName());
            applyDResp.setRegion(orgStoreBaseRpcDTO.getRegion());
            applyDResp.setRegionName(orgStoreBaseRpcDTO.getRegionName());
            applyDResp.setStoreType2(orgStoreBaseRpcDTO.getStoreType2());
            String storeTypeName = storeType2.get(orgStoreBaseRpcDTO.getStoreType2());
            if (storeTypeName != null) {
                applyDResp.setStoreType2Name(storeTypeName);
            }
            res.add(applyDResp);
        }
        return res;
    }

    private void intersectSets(Set<Long> set1, List<Long> list2) {
        if (set1.isEmpty()) {
            set1.addAll(list2);
        }
        set1.retainAll(list2);
    }

    public ScpPurLimitSettingServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, ScpPurLimitSettingDomainService scpPurLimitSettingDomainService, ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService, ScpPurLimitSettingRegionDomainService scpPurLimitSettingRegionDomainService, ScpPurLimitSettingStoreDomainService scpPurLimitSettingStoreDomainService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RedisTemplate<String, Object> redisClient, ScpPurLimitSettingRepo scpPurLimitSettingRepo, RmiItemService rmiItemService, RmiSysUDCService rmiSysUDCService) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpPurLimitSettingDomainService = scpPurLimitSettingDomainService;
        this.scpPurLimitSettingItemDomainService = scpPurLimitSettingItemDomainService;
        this.scpPurLimitSettingRegionDomainService = scpPurLimitSettingRegionDomainService;
        this.scpPurLimitSettingStoreDomainService = scpPurLimitSettingStoreDomainService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.redisClient = redisClient;
        this.scpPurLimitSettingRepo = scpPurLimitSettingRepo;
        this.rmiItemService = rmiItemService;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

