/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingItemSaveVO;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingItemConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingItemDO;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingRedisDO;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingItemDomainService;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingItemRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingItemRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpPurLimitSettingItemDomainServiceImpl
implements ScpPurLimitSettingItemDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpPurLimitSettingItemDomainServiceImpl.class);
    private final RedisTemplate redisTemplate;
    private final ScpPurLimitSettingItemRepo scpPurLimitSettingItemRepo;
    private final ScpPurLimitSettingItemRepoProc scpPurLimitSettingItemRepoProc;

    @Override
    @SysCodeProc
    public List<ScpPurLimitSettingItemRespVO> findByMasId(Long masId) {
        List<ScpPurLimitSettingItemDO> settingItemDOS = this.scpPurLimitSettingItemRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpPurLimitSettingItemConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpPurLimitSettingItemRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSavePurLimitSettingItem(List<ScpPurLimitSettingItemSaveVO> saveVOS) {
        this.scpPurLimitSettingItemRepo.saveAll(ScpPurLimitSettingItemConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpPurLimitSettingItemRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpPurLimitSettingItemRepo.deleteByIds(ids);
    }

    @Override
    public List<ScpPurLimitSettingItemRespVO> getEnablePurLimitSettingItemByStoreCode(String storeCode, List<String> itemTypes) {
        ArrayList<ScpPurLimitSettingItemRespVO> respVOS = new ArrayList<ScpPurLimitSettingItemRespVO>();
        Object obj = this.redisTemplate.opsForValue().get((Object)("SCP:PUR_LIMIT:SETTING:" + storeCode));
        if (obj == null) {
            return new ArrayList<ScpPurLimitSettingItemRespVO>();
        }
        String str = (String)obj;
        ScpPurLimitSettingRedisDO setting = (ScpPurLimitSettingRedisDO)JSON.parseObject((String)str, ScpPurLimitSettingRedisDO.class);
        List<ScpPurLimitSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
        for (ScpPurLimitSettingRedisDO.ActivityDO activityDO : activityList) {
            log.info("getEnablePurLimitSettingItemByStoreCode:{}", (Object)JSONUtil.toJsonStr((Object)activityDO));
            Object key = this.redisTemplate.opsForValue().get((Object)("SCP:PUR_LIMIT:SETTING:" + activityDO.getActivityId()));
            if (key == null) {
                log.info("\u9650\u8d2d\u6d3b\u52a8ID:{}\uff0c\u7f13\u5b58\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId());
                continue;
            }
            if (LocalDateTime.now().isBefore(activityDO.getValidFrom()) || LocalDateTime.now().isAfter(activityDO.getValidTo())) {
                log.info("\u9650\u8d2d\u6d3b\u52a8ID:{}\uff0c\u5df2\u8fc7\u671f", (Object)activityDO.getActivityId());
                continue;
            }
            List<ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
            for (ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                if (!itemTypes.contains(innerItemDO.getItemType2())) {
                    log.info("\u9650\u8d2d\u6d3b\u52a8ID:{}\uff0c\u5546\u54c1\u5206\u7c7b:{}\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId(), (Object)innerItemDO.getItemType2());
                    continue;
                }
                ScpPurLimitSettingItemRespVO scpPurLimitSettingItemRespVO = new ScpPurLimitSettingItemRespVO();
                scpPurLimitSettingItemRespVO.setItemId(innerItemDO.getItemId());
                scpPurLimitSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                scpPurLimitSettingItemRespVO.setItemName(innerItemDO.getItemName());
                scpPurLimitSettingItemRespVO.setMasId(innerItemDO.getMasId());
                scpPurLimitSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                scpPurLimitSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                scpPurLimitSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                respVOS.add(scpPurLimitSettingItemRespVO);
            }
        }
        return respVOS;
    }

    @Override
    public List<Long> findMasIdByItemId(Long itemId) {
        return this.scpPurLimitSettingItemRepoProc.findMasIdByItemId(itemId);
    }

    public ScpPurLimitSettingItemDomainServiceImpl(RedisTemplate redisTemplate, ScpPurLimitSettingItemRepo scpPurLimitSettingItemRepo, ScpPurLimitSettingItemRepoProc scpPurLimitSettingItemRepoProc) {
        this.redisTemplate = redisTemplate;
        this.scpPurLimitSettingItemRepo = scpPurLimitSettingItemRepo;
        this.scpPurLimitSettingItemRepoProc = scpPurLimitSettingItemRepoProc;
    }
}

