/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.survey;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoQueryVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoRespVO;
import com.elitesland.scp.domain.convert.survey.SurveyConvert;
import com.elitesland.scp.domain.convert.survey.SurveyOptionConvert;
import com.elitesland.scp.domain.convert.survey.SurveyPublishConvert;
import com.elitesland.scp.domain.convert.survey.SurveyQuestionConvert;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.elitesland.scp.domain.entity.survey.SurveyDO;
import com.elitesland.scp.domain.entity.survey.SurveyOptionDO;
import com.elitesland.scp.domain.entity.survey.SurveyPublishDO;
import com.elitesland.scp.domain.entity.survey.SurveyQuestionDO;
import com.elitesland.scp.domain.service.survey.SurveyService;
import com.elitesland.scp.domain.vo.survey.SurveyOptionRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyOptionSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyPublishParam;
import com.elitesland.scp.domain.vo.survey.SurveyPublishSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyQuestionRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyQuestionSaveParam;
import com.elitesland.scp.domain.vo.survey.SurveyRespVO;
import com.elitesland.scp.domain.vo.survey.SurveySaveParam;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.scpsman.SalesmanRegionRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.survey.SurveyOptionRepo;
import com.elitesland.scp.infr.repo.survey.SurveyPublishRepo;
import com.elitesland.scp.infr.repo.survey.SurveyQuestionRepo;
import com.elitesland.scp.infr.repo.survey.SurveyRepo;
import com.elitesland.scp.infr.repo.survey.SurveyRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SurveyServiceImpl
implements SurveyService {
    private static final Logger log = LoggerFactory.getLogger(SurveyServiceImpl.class);
    private final SurveyRepo surveyRepo;
    private final SurveyRepoProc surveyRepoProc;
    private final SurveyQuestionRepo surveyQuestionRepo;
    private final SurveyOptionRepo surveyOptionRepo;
    private final SurveyPublishRepo surveyPublishRepo;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final SalesmanRegionRepo salesmanRegionRepo;

    @Override
    @SysCodeProc
    public PagingVO<SurveyRespVO> search(SurveyPagingParam searchParam) {
        PagingVO<SurveyRespVO> search = this.surveyRepoProc.search(searchParam);
        if (search.getTotal() > 0L) {
            List records = search.getRecords();
            List<Long> suvIdList = records.stream().map(SurveyRespVO::getId).toList();
            Map<Long, List<SurveyPublishDO>> publishMap = this.surveyPublishRepo.findBySuvIdIn(suvIdList).stream().collect(Collectors.groupingBy(SurveyPublishDO::getSuvId));
            for (SurveyRespVO surveyRespVO : records) {
                if (!publishMap.containsKey(surveyRespVO.getId())) continue;
                String collect = publishMap.get(surveyRespVO.getId()).stream().map(SurveyPublishDO::getOuName).collect(Collectors.joining(","));
                surveyRespVO.setPublishOuName(collect);
            }
        }
        return search;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(SurveySaveParam saveVO) {
        SurveyDO surveyDO = SurveyConvert.INSTANCE.saveVOToDo(saveVO);
        surveyDO.setSurveyStatus(ScpUdcEnum.SURVEY_STATUS_10.getValueCode());
        SurveyDO save = (SurveyDO)this.surveyRepo.save(surveyDO);
        List<SurveyQuestionDO> questionDOList = this.surveyQuestionRepo.findBySuvId(save.getId());
        if (CollectionUtils.isNotEmpty(questionDOList)) {
            List<Long> qusIdList = questionDOList.stream().map(BaseModel::getId).toList();
            this.surveyQuestionRepo.deleteByIdIn(qusIdList);
            this.surveyOptionRepo.deleteByQusIdIn(qusIdList);
        }
        if (CollectionUtils.isNotEmpty(saveVO.getQuestionList())) {
            for (SurveyQuestionSaveParam questionVO : saveVO.getQuestionList()) {
                SurveyQuestionDO questionDO = SurveyQuestionConvert.INSTANCE.saveParamToDo(questionVO);
                questionDO.setSuvId(save.getId());
                SurveyQuestionDO question = (SurveyQuestionDO)this.surveyQuestionRepo.save(questionDO);
                if (!CollectionUtils.isNotEmpty(questionVO.getOptionList())) continue;
                for (SurveyOptionSaveParam optionVO : questionVO.getOptionList()) {
                    SurveyOptionDO optionDO = SurveyOptionConvert.INSTANCE.saveParamToDo(optionVO);
                    optionDO.setQusId(question.getId());
                    this.surveyOptionRepo.save(optionDO);
                }
            }
        }
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(List<Long> idList) {
        this.surveyRepoProc.updateSurveyStatus(idList, ScpUdcEnum.SURVEY_STATUS_30.getValueCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer publish(SurveyPublishParam param) {
        if (param.getId() == null || CollectionUtils.isEmpty(param.getPublishList())) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        List<SurveyPublishDO> publishDOS = this.surveyPublishRepo.findBySuvId(param.getId());
        List<String> ouCodes = publishDOS.stream().map(SurveyPublishDO::getOuCode).toList();
        ArrayList<SurveyPublishDO> publishList = new ArrayList<SurveyPublishDO>();
        for (SurveyPublishSaveParam publishParam : param.getPublishList()) {
            if (ouCodes.contains(publishParam.getOuCode())) continue;
            SurveyPublishDO publishDO = SurveyPublishConvert.INSTANCE.saveParamToDo(publishParam);
            publishDO.setSuvId(param.getId());
            publishDO.setFillStatus(ScpUdcEnum.SURVEY_FILL_STATUS_00.getValueCode());
            publishList.add(publishDO);
        }
        if (CollectionUtils.isNotEmpty(publishList)) {
            this.surveyPublishRepo.saveAll(publishList);
        }
        this.surveyRepoProc.updateSurveyStatus(Collections.singletonList(param.getId()), ScpUdcEnum.SURVEY_STATUS_20.getValueCode());
        return publishList.size();
    }

    @Override
    @SysCodeProc
    public SurveyRespVO get(Long id) {
        Optional byId = this.surveyRepo.findById(id);
        if (byId.isEmpty()) {
            throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728");
        }
        SurveyRespVO surveyRespVO = SurveyConvert.INSTANCE.doToRespVO((SurveyDO)byId.get());
        List<SurveyQuestionDO> questionDOList = this.surveyQuestionRepo.findBySuvId(id);
        if (CollectionUtils.isNotEmpty(questionDOList)) {
            List<SurveyQuestionRespVO> questionRespVOList = SurveyQuestionConvert.INSTANCE.doListToRespVOList(questionDOList);
            List<Long> qusIdList = questionRespVOList.stream().map(SurveyQuestionRespVO::getId).distinct().toList();
            Map<Long, List<SurveyOptionDO>> collect = this.surveyOptionRepo.findByQusIdIn(qusIdList).stream().collect(Collectors.groupingBy(SurveyOptionDO::getQusId));
            for (SurveyQuestionRespVO questionRespVO : questionRespVOList) {
                if (!collect.containsKey(questionRespVO.getId())) continue;
                List<SurveyOptionDO> surveyOptionDOList = collect.get(questionRespVO.getId());
                List<SurveyOptionRespVO> optionRespVOList = SurveyOptionConvert.INSTANCE.doListToRespVOList(surveyOptionDOList);
                questionRespVO.setOptionList(optionRespVOList);
            }
            surveyRespVO.setQuestionList(questionRespVOList);
        }
        return surveyRespVO;
    }

    @Override
    public SurveyRespVO findSurvey() {
        List<ScpsmanRegionDO> regionDO;
        GeneralUserDetails generalUserDetails = SecurityContextUtil.currentUser();
        if (generalUserDetails == null || generalUserDetails.getUser() == null) {
            log.info("\u83b7\u53d6\u95ee\u5377\uff1a\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        SalesmanInfoQueryVO queryVO = new SalesmanInfoQueryVO();
        queryVO.setLoginAccount(generalUserDetails.getUser().getUsername());
        JPAQuery<SalesmanInfoRespVO> jpaQuery = this.scpsmanInfoRepoProc.findSalesmanInfo(queryVO);
        List salesmanInfoList = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)salesmanInfoList)) {
            log.info("\u83b7\u53d6\u95ee\u5377\uff1a\u8ba2\u8d27\u8d26\u53f7\u4e3a\u7a7a");
            return null;
        }
        SalesmanInfoRespVO salesmanInfoRespVO = (SalesmanInfoRespVO)salesmanInfoList.get(0);
        if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(salesmanInfoRespVO.getScpsmanType()) && CollectionUtils.isNotEmpty(regionDO = this.salesmanRegionRepo.findByMasIdIn(List.of(salesmanInfoRespVO.getId())))) {
            String regionCode = regionDO.get(0).getRegionCode();
            SurveyPagingParam param = new SurveyPagingParam();
            param.setNeedFilterValidTime("Y");
            param.setOuCode(regionCode);
            param.setSurveyStatus(ScpUdcEnum.SURVEY_STATUS_20.getValueCode());
            param.setFillStatus(ScpUdcEnum.SURVEY_FILL_STATUS_00.getValueCode());
            List<SurveyRespVO> survey = this.surveyRepoProc.findSurvey(param);
            if (CollectionUtils.isNotEmpty(survey)) {
                return this.get(survey.get(0).getId());
            }
        }
        return null;
    }

    public SurveyServiceImpl(SurveyRepo surveyRepo, SurveyRepoProc surveyRepoProc, SurveyQuestionRepo surveyQuestionRepo, SurveyOptionRepo surveyOptionRepo, SurveyPublishRepo surveyPublishRepo, ScpsmanInfoRepoProc scpsmanInfoRepoProc, SalesmanRegionRepo salesmanRegionRepo) {
        this.surveyRepo = surveyRepo;
        this.surveyRepoProc = surveyRepoProc;
        this.surveyQuestionRepo = surveyQuestionRepo;
        this.surveyOptionRepo = surveyOptionRepo;
        this.surveyPublishRepo = surveyPublishRepo;
        this.scpsmanInfoRepoProc = scpsmanInfoRepoProc;
        this.salesmanRegionRepo = salesmanRegionRepo;
    }
}

