package com.elitesland.scp.application.facade.vo.serviceconfig;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author chaofeng.xia
 * @since 2025/5/26
 */
@Data
@ApiModel(value = "ScpWhNetRelationImportVO", description = "仓网关系导入")
public class ScpServiceConfigImportVO implements Serializable {

    @ApiModelProperty("费用归属类型")
    @SysCode(sys = "yst-suplan", mod = "SC_FEE_TYPE")
    private String feeType;
    private String feeTypeName;

    @ApiModelProperty("费用归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("费用归属公司编码")
    private String ouCode;

    @ApiModelProperty("费用归属公司名称")
    private String ouName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "SERVICE_CONFIG_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("区域id/门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long regionStoreId;

    @ApiModelProperty("区域编码/门店编码")
    private String regionStoreCode;

    @ApiModelProperty("区域名称/门店名称")
    private String regionStoreName;

    @ApiModelProperty("适用门店等级")
    private String storeLevel;
    private String storeLevelName;

    @ApiModelProperty("费用比例")
    private BigDecimal feePercentageStr;

    @ApiModelProperty("业务主键")
    private String businessKey;
}
