package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invstk.InvStkMpQueryRpcParam;
import com.elitesland.inv.dto.invstk.InvStkStoreMpRpcDTO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppInvStkRespVO;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreWhDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class AppInvStkServiceImpl implements AppInvStkService {

    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;

    @Override
    public PagingVO<AppInvStkRespVO> page(AppItemPageParamVO appItemPageParamVO) {
        List<AppInvStkRespVO> resultList = new ArrayList<>();
        List<Long> itemIdList = scpCateItemRepoProc.appItemSku(appItemPageParamVO);
        // 查询库存信息
        List<String> whCodes = new ArrayList<>();
        if (appItemPageParamVO.getWhCode() != null) {
            whCodes.add(appItemPageParamVO.getWhCode());
        } else {
            Map<String, List<OrgStoreWhDTO>> storeWhListCache = SysUtils.getStoreWhListCache(List.of(appItemPageParamVO.getStoreCode()));
            List<OrgStoreWhDTO> orgStoreWhDTOS = storeWhListCache.get(appItemPageParamVO.getStoreCode());
            if (CollectionUtils.isEmpty(orgStoreWhDTOS)) {
                throw new BusinessException(ApiCode.FAIL, "门店未配置仓库信息，请检查");
            }
            List<String> storeWhCodes = orgStoreWhDTOS.stream().map(OrgStoreWhDTO::getWhCode).distinct().collect(Collectors.toList());
            whCodes.addAll(storeWhCodes);
        }
        InvStkMpQueryRpcParam stkParam = new InvStkMpQueryRpcParam();
        stkParam.setWhCodes(whCodes);
        stkParam.setItemIds(itemIdList);
        stkParam.setCurrent(appItemPageParamVO.getCurrent() + 2);
        stkParam.setSize(appItemPageParamVO.getSize());
        stkParam.setFilterStockGtZero(appItemPageParamVO.getFilterStockGtZero());
        PagingVO<InvStkStoreMpRpcDTO> pagingVO = rmiInvStkRpcService.queryStoreMpInvStkMap(stkParam);
        if (pagingVO.getTotal() == 0) {
            return new PagingVO<>();
        }
        //查询商品基础信息
        List<Long> stockItemIds = pagingVO.getRecords().stream().map(InvStkStoreMpRpcDTO::getItemId).distinct().collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(stockItemIds);
        List<ItmItemScpBaseRpcDTO> itemRpcDTOS = rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        Map<Long, ItmItemScpBaseRpcDTO> skuMap = itemRpcDTOS.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));

        for (InvStkStoreMpRpcDTO item : pagingVO.getRecords()) {
            AppInvStkRespVO appInvStkRespVO = new AppInvStkRespVO();
            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = skuMap.get(item.getItemId());
            appInvStkRespVO.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
            appInvStkRespVO.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
            appInvStkRespVO.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
            appInvStkRespVO.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
            appInvStkRespVO.setItemId(itmItemScpBaseRpcDTO.getId());
            appInvStkRespVO.setItemCode(itmItemScpBaseRpcDTO.getItemCode());
            appInvStkRespVO.setItemName(itmItemScpBaseRpcDTO.getItemName());
            appInvStkRespVO.setUom(itmItemScpBaseRpcDTO.getUom());
            appInvStkRespVO.setUomName(itmItemScpBaseRpcDTO.getUomName());
            appInvStkRespVO.setReceiveUom(itmItemScpBaseRpcDTO.getReceiveUom());
            appInvStkRespVO.setReceiveUomName(itmItemScpBaseRpcDTO.getReceiveUomName());
            appInvStkRespVO.setItemAttr2(itmItemScpBaseRpcDTO.getItemAttr2());
            appInvStkRespVO.setItemAttrName(itmItemScpBaseRpcDTO.getItemAttrName());
            List<ItmItemAttachmentRpcDTO> spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty(spuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                appInvStkRespVO.setImgUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
            }
            BigDecimal receiveUomRatio = itmItemScpBaseRpcDTO.getReceiveUomRatio();
            BigDecimal ohQty = item.getOhQty();
            if (ohQty.compareTo(BigDecimal.ZERO) > 0 && receiveUomRatio != null) {
                if (appInvStkRespVO.getUom().equals(appInvStkRespVO.getReceiveUom())) {
                    appInvStkRespVO.setOhQty(ohQty);
                } else {
                    // 计算商的整数部分
                    BigDecimal quotient = ohQty.divide(receiveUomRatio, 0, RoundingMode.DOWN);
                    // 计算余数
                    BigDecimal remainder = ohQty.remainder(receiveUomRatio);
                    appInvStkRespVO.setOhQty(quotient);
                    appInvStkRespVO.setRemQty(remainder);
                }
            } else {
                appInvStkRespVO.setOhQty(BigDecimal.ZERO);
                appInvStkRespVO.setRemQty(BigDecimal.ZERO);
            }
            resultList.add(appInvStkRespVO);
        }
        return new PagingVO<>(pagingVO.getTotal(), resultList);
    }
}
