package com.elitesland.scp.application.web.app;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.app.OrgStoreListParam;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.application.facade.vo.resp.app.OrgStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreDemandCalendarRespVO;
import com.elitesland.scp.application.service.app.AppStoreListService;
import com.elitesland.support.provider.org.param.OrgStoreRpcParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping(value = "/app/store", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "移动端-门店列表", tags = {"移动端-门店列表"})
@AllArgsConstructor
public class AppStoreListController {

    private final AppStoreListService appStoreListService;

    @ApiOperation("移动端 - 门店列表")
    @PostMapping("/list")
    public ApiResult<List<OrgStoreRespVO>> list(@RequestBody @Validated OrgStoreListParam param) {
        return ApiResult.ok(appStoreListService.list(param));
    }


}
