package com.elitesland.scp.application.web.survey;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.service.survey.SurveyService;
import com.elitesland.scp.domain.vo.survey.*;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/survey/manage", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "问卷管理")
@Slf4j
@RequiredArgsConstructor
public class SurveyController {

    private final SurveyService surveyService;

    @PostMapping(value = "search")
    @ApiOperation(value = "分页列表")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SurveyRespVO>> search(@RequestBody SurveyPagingParam searchParam) {
        return ApiResult.ok(surveyService.search(searchParam));
    }

    @PostMapping(value = "save")
    @ApiOperation(value = "编辑保存")
    @ApiOperationSupport(order = 2)
    public ApiResult<Long> surveySave(@RequestBody @Validated SurveySaveParam saveVO) {
        return ApiResult.ok(surveyService.saveOrUpdate(saveVO));
    }

    @PostMapping(value = "cancel")
    @ApiOperation(value = "作废")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> cancel(@RequestBody List<Long> idList) {
        surveyService.cancel(idList);
        return ApiResult.ok();
    }

    @PostMapping(value = "/publish")
    @ApiOperation(value = "发布")
    @ApiOperationSupport(order = 4)
    public ApiResult<Integer> publish(@RequestBody SurveyPublishParam param) {
        try {
            return ApiResult.ok(surveyService.publish(param));
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value = "/get/{id}")
    @ApiOperation(value = "详情")
    @ApiOperationSupport(order = 5)
    public ApiResult<SurveyRespVO> get(@PathVariable Long id) {
        try {
            return ApiResult.ok(surveyService.get(id));
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value = "/findSurvey")
    @ApiOperation(value = "查询当前用户是否有问卷需要填写")
    @ApiOperationSupport(order = 6)
    public ApiResult<SurveyRespVO> findSurvey() {
        try {
            return ApiResult.ok(surveyService.findSurvey());
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value = "/fillSurvey")
    @ApiOperation(value = "填写问卷")
    @ApiOperationSupport(order = 7)
    public ApiResult<Object> fillSurvey(@RequestBody List<SurveyAnswerSaveParam> saveParamList) {
        try {
            surveyService.fillSurvey(saveParamList);
            return ApiResult.ok();
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

}