package com.elitesland.scp.domain.entity.stock;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
* @description: 供应链计划-安全库存目标库存
* @author: jeesie.jiang
* @create: 2025-01-15
* @Version 1.0
**/
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_safety_target_stock")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@org.hibernate.annotations.Table(appliesTo = "scp_safety_target_stock", comment = "供应链计划-安全库存目标库存")
public class ScpSafetyTargetStockDO extends BaseModel implements Serializable {

    @Column(name = "ou_id", columnDefinition = "bigint")
    @Comment("公司ID")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40)")
    @Comment("公司编码")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(48)")
    @Comment("公司名称")
    private String ouName;

    @Column(name = "wh_id", columnDefinition = "bigint")
    @Comment("仓库ID")
    private Long whId;

    @Column(name = "wh_code", columnDefinition = "varchar(40)")
    @Comment("仓库编码")
    private String whCode;

    @Column(name = "wh_name", columnDefinition = "varchar(48)")
    @Comment("仓库名称")
    private String whName;

    @Column(name = "item_id", columnDefinition = "bigint")
    @Comment("商品ID")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40)")
    @Comment("商品编码")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(48)")
    @Comment("商品名称")
    private String itemName;

    @Column(name = "safety_qty", columnDefinition = "decimal(20,8)")
    @Comment("安全库存")
    private BigDecimal safetyQty;

    @Column(name = "target_qty", columnDefinition = "decimal(20,8)")
    @Comment("安全库存")
    private BigDecimal targetQty;

    @Column(name = "plan_uom", columnDefinition = "varchar(10)")
    @Comment("计划单位")
    private String planUom;

    @Column(name = "uom", columnDefinition = "varchar(10)")
    @Comment("计划基本单位")
    private String uom;

    @Column(name = "limit1", columnDefinition = "varchar(40)")
    @Comment("库存类型")
    private String limit1;

    @Column(name = "item_type2", columnDefinition = "varchar(40)")
    @Comment("商品类型2")
    private String itemType2;

    @Column(name = "item_cate_code", columnDefinition = "varchar(40)")
    @Comment("商品类型2")
    private String itemCateCode;

    @Column(name = "brand", columnDefinition = "varchar(40)")
    @Comment("品牌")
    private String brand;

    @Column(name = "business_id", columnDefinition = "varchar(63)")
    @Comment("业务keyID")
    private String businessId;





}