package com.elitesland.scp.domain.service.alloc;

import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingItemSaveVO;

import java.util.List;

public interface ScpAllocSettingItemDomainService {


    /**
     * 订货强配活动明细查询
     *
     * @param masId
     * @return
     */
    List<ScpAllocSettingItemRespVO> findByMasId(Long masId);

    /**
     * 订货强配活动明细保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSaveAllocSettingItem(List<ScpAllocSettingItemSaveVO> saveVOS);

    /**
     * 删除订货强配活动明细
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动明细
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据门店编码查询订货强配活动明细
     *
     * @param storeCode
     * @param docType
     * @param itemTypes
     * @return
     */
    List<ScpAllocSettingItemRespVO> getEnableAllocSettingItemByStoreCode(String storeCode, String docType, List<String> itemTypes);

    List<ScpAllocSettingItemRespVO> getEnableAllocSettingItemByStoreCode(String storeCode, String docType);

        /**
     * 根据门店查询
     *
     * @param storeId
     * @return
     */
    List<Long> findMasIdByItemId(Long storeId);
}
