package com.elitesland.scp.domain.service.item;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.param.CateItemRpcParam;

import java.util.List;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/3 11:39 上午
 * @version:v1.0
 */
public interface ScpCateItemDomainService {


    void saveBatch(List<ScpCateItemDO> scpCateItemDOS);


    void delete(List<Long> ids);

    ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam);

    /**
     * 是否存在商品
     * @param itemCodes
     * @return
     */
    List<String> existByItemCodes(List<String> itemCodes);

    /**
     * 热销管理
     * @param paramVO
     */
    void changeHotFlag(ScpCateItemHotParamVO paramVO);

    /**
     * 商品分页查询
     * @param paramVO
     * @return
     */
    PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO);

    /**
     * 修改排序号
     * @param id
     * @param sorNo
     */
    void saveSorNo(Long id, Integer sorNo);

    /**
     * PC商品维护分页
     * @param paramVO
     * @return
     */
    PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO);
}
