package com.elitesland.scp.domain.service.mrp;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDetailRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDDO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/1/15
 */
public interface ScpMrpDDomainService {

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 结果
     */
    PagingVO<ScpMrpDRespVO> searchPage(ScpMrpDPageParam param);

    List<ScpMrpDRespVO> findByMasId(Long masId);

    void deleteByMasIds(List<Long> masIds);

    void deleteByIds(List<Long> ids);

    List<Long> findIdsByMasIds(List<Long> ids);

    List<ScpMrpDRespVO> findByMasIds(List<Long> masIds);

    ScpMrpDRespVO findById(Long id);

    List<ScpMrpDDO> save(List<ScpMrpDDO> scpMrpDDOList);

    void savePlan(List<ScpMrpDPlanSaveVO> scpMrpDPlanSaveVOList);

    PagingVO<ScpMrpDExportRespVO> queryExport(ScpMrpDPageParam param);

    List<ScpMrpDRespVO> findByIds(List<Long> ids);

    void updateNetDemand(Long id, BigDecimal netDemand);

    List<ScpMrpDetailRespVO> findDetailByMasId(Long id);

}