package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingItemSaveVO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingItemConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingItemDO;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingRedisDO;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingItemRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingItemRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


@Slf4j
@Service
@RequiredArgsConstructor
public class ScpPurLimitSettingItemDomainServiceImpl implements ScpPurLimitSettingItemDomainService {

    private final RedisTemplate redisTemplate;
    private final ScpPurLimitSettingItemRepo scpPurLimitSettingItemRepo;
    private final ScpPurLimitSettingItemRepoProc scpPurLimitSettingItemRepoProc;

    @Override
    @SysCodeProc
    public List<ScpPurLimitSettingItemRespVO> findByMasId(Long masId) {
        List<ScpPurLimitSettingItemDO> settingItemDOS = scpPurLimitSettingItemRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpPurLimitSettingItemConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSavePurLimitSettingItem(List<ScpPurLimitSettingItemSaveVO> saveVOS) {
        scpPurLimitSettingItemRepo.saveAll(ScpPurLimitSettingItemConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpPurLimitSettingItemRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpPurLimitSettingItemRepo.deleteByIds(ids);
    }

    @Override
    public List<ScpPurLimitSettingItemRespVO> getEnablePurLimitSettingItemByStoreCode(String storeCode, List<String> itemTypes) {
        List<ScpPurLimitSettingItemRespVO> respVOS = new ArrayList<>();
        Object obj = redisTemplate.opsForValue().get(ScpConstant.PUR_LIMIT_SETTING + storeCode);
        if (obj == null) {
            return new ArrayList<>();
        }
        String str = (String) obj;
        var setting = JSON.parseObject(str, ScpPurLimitSettingRedisDO.class);
        List<ScpPurLimitSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
        for (ScpPurLimitSettingRedisDO.ActivityDO activityDO : activityList) {
            log.info("getEnablePurLimitSettingItemByStoreCode:{}", JSONUtil.toJsonStr(activityDO));
            Object key = redisTemplate.opsForValue().get(ScpConstant.PUR_LIMIT_SETTING + activityDO.getActivityId());
            if (key == null) {
                log.info("限购活动ID:{}，缓存不存在", activityDO.getActivityId());
                continue;
            }
            if (LocalDateTime.now().isBefore(activityDO.getValidFrom()) || LocalDateTime.now().isAfter(activityDO.getValidTo())) {
                log.info("限购活动ID:{}，已过期", activityDO.getActivityId());
                continue;
            }
            List<ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
            for (ScpPurLimitSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                if (!itemTypes.contains(innerItemDO.getItemType2())) {
                    log.info("限购活动ID:{}，商品分类:{}不存在", activityDO.getActivityId(), innerItemDO.getItemType2());
                    continue;
                }
                ScpPurLimitSettingItemRespVO scpPurLimitSettingItemRespVO = new ScpPurLimitSettingItemRespVO();
                scpPurLimitSettingItemRespVO.setItemId(innerItemDO.getItemId());
                scpPurLimitSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                scpPurLimitSettingItemRespVO.setItemName(innerItemDO.getItemName());
                scpPurLimitSettingItemRespVO.setMasId(innerItemDO.getMasId());
                scpPurLimitSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                scpPurLimitSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                scpPurLimitSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                respVOS.add(scpPurLimitSettingItemRespVO);
            }
        }
        return respVOS;
    }

    @Override
    public List<Long> findMasIdByItemId(Long itemId) {
        return scpPurLimitSettingItemRepoProc.findMasIdByItemId(itemId);
    }
}
