package com.elitesland.scp.domain.vo.article;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@ApiModel(description = "文章分类新增编辑入参")
@Data
public class ArticleCategorySaveVO implements Serializable {
    private static final long serialVersionUID = 632396646377721743L;

    @ApiModelProperty(value = "文章分类id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "文章分类名称")
    @NotBlank(message = "分类名称不能为空")
    private String categoryName;

    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    @NotBlank(message = "是否显示不能为空")
    private String showFlag;

    @ApiModelProperty(value = "上级分类id")
    private Long pid;

    @ApiModelProperty(value = "上级分类id集合")
    private List<Long> pidList;

    private Long rootId;

//    @ApiModelProperty(value = "上级分类名称")
//    private String pName;
}
