package com.elitesland.scp.domain.vo.survey;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

@ApiModel(description = "问卷出参")
@Data
public class SurveyQuestionRespVO implements Serializable {

    private static final long serialVersionUID = 44067892996016803L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("问卷ID")
    @Column(name = "suv_id")
    private Long suvId;

    @ApiModelProperty("问题类型")
    private String qusType;

    @ApiModelProperty("问题标题")
    private String qusTitle;

    @ApiModelProperty("序号")
    private Integer sortNo;

    @ApiModelProperty("选项列表")
    private List<SurveyOptionRespVO> optionList;

}
