package com.elitesland.scp.application.facade.vo.resp.authority;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 计划权限分配明细VO
 * @author : wz
 * @date : 2024-3-18
 */
@Data
@ApiModel(value = "计划权限分配明细", description = "计划权限分配明细")
public class ScpsmanAuthorityDRespVO implements Serializable {
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 主表id */
    @ApiModelProperty(name = "主表id")
    private Long masId ;

    /** 类型 */
    @ApiModelProperty(name = "类型")
    @JsonSerialize(using = ToStringSerializer.class)
    @SysCode(sys = "yst-suplan", mod = "SCPSMAN_AUTHORITY_TYPE")
    private int type ;
    private String typeName;

    /** 门店id/仓库id */
    @ApiModelProperty(name = "门店id/仓库id")
    private Long stWhId;

    /**
     * 门店编码/仓库编码
     */
    @ApiModelProperty(name = "门店编码/仓库编码")
    private String stWhCode;

    /**
     * 门店名称/仓库名称
     */
    @ApiModelProperty(name = "门店名称/仓库名称")
    private String stWhName;

//    @SysCode(sys = "yst-supp", mod = "REGION")
    @ApiModelProperty("区域")
    private String region;
    @ApiModelProperty("区域名称")
    private String regionName;

    @ApiModelProperty(value = "权限来源，[UDC]yst-suplan:AUTH_SOURCE")
    @SysCode(sys = "yst-suplan", mod = "AUTH_SOURCE")
    private String authSource;
    private String authSourceName;
}