package com.elitesland.scp.application.service.serviceconfig;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.*;

import java.util.List;
import java.util.Map;

/**
 * @author chaofeng.xia
 * @since 2025/5/26
 */
public interface ScpServiceConfigService {


    /**
     * 项目服务配置分页返回
     *
     * @param queryParam 查询参数
     * @return 结果
     */
    PagingVO<ScpServiceConfigPageVO> page(ScpServiceConfigPageParamVO queryParam);


    /**
     * 项目服务配置新增
     *
     * @param createParams 新建参数
     */
    void createServiceConfig(List<ScpServiceConfigSaveVO> createParams);

    /**
     * 项目服务配置修改
     *
     * @param createParam 修改参数
     */
    void modifyServiceConfig(ScpServiceConfigSaveVO createParam);

    /**
     * 查询同组合下明细
     *
     * @param id id
     * @return 结果
     */
    ScpServiceConfigRespVO findDetailById(Long id);


    /**
     * 删除-逻辑
     *
     * @param ids ids
     */
    void deleteServiceConfig(List<Long> ids);

    /**
     * 导出
     *
     * @param queryParam 查询条件
     * @return 结果
     */
    PagingVO<ScpServiceConfigExportRespVO> exportSearch(ScpServiceConfigPageParamVO queryParam);

    List<String> executeImport(List<ScpServiceConfigImportVO> dataList, int startRowIndex);

    Map<String,ScpServiceConfigRespVO> findServiceConfigGroupByStore(String storeCode,String regionCode,String level);

    Map<String,ScpServiceConfigRespVO> checkServiceConfig(String storeCode,String regionCode,String level);
}