package com.elitesland.scp.domain.entity.survey;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "scp_survey", indexes = {
})
@Comment("问卷")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SurveyDO extends BaseModel implements Serializable {
    @Serial
    private static final long serialVersionUID = -4254921460115216468L;

    @ApiModelProperty("问卷标题")
    @Column(name = "survey_title")
    private String surveyTitle;

    @ApiModelProperty("问卷描述")
    @Column(name = "survey_desc")
    private String surveyDesc;

    @ApiModelProperty("开始时间")
    @Column(name = "begin_time")
    private LocalDateTime beginTime;

    @ApiModelProperty("结束时间")
    @Column(name = "end_time")
    private LocalDateTime endTime;

    @ApiModelProperty("问卷状态")
    @Column(name = "survey_status")
    private String surveyStatus;

    @ApiModelProperty("发布人")
    @Column(name = "publisher_id")
    private Long publisherId;

    @ApiModelProperty("发布人")
    @Column(name = "publisher_name")
    private String publisherName;

    @ApiModelProperty("填写数量")
    @Column(name = "fill_count")
    private Integer fillCount;




}
