package com.elitesland.scp.infr.repo.alloc;

import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingBrandDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpAllocSettingBrandRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingBrandDO scpAllocSettingBrandDO = QScpAllocSettingBrandDO.scpAllocSettingBrandDO;

    public List<Long> findMasIdByBrand(String brand) {
        var jpaQuery = jpaQueryFactory.select(scpAllocSettingBrandDO.masId).distinct()
                .from(scpAllocSettingBrandDO);
        jpaQuery.where(scpAllocSettingBrandDO.brand.eq(brand));
        return jpaQuery.fetch();
    }

}
