package com.elitesland.scp.infr.repo.minOrder;

import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingItemRespVO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingDO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingItemDO;
import com.elitesland.scp.domain.entity.minOrder.QScpMinOrderSettingStoreDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpMinOrderSettingItemRepoProc {
    private static final QScpMinOrderSettingStoreDO scpMinOrderSettingStoreDO = QScpMinOrderSettingStoreDO.scpMinOrderSettingStoreDO;
    private static final QScpMinOrderSettingDO scpMinOrderSettingDO = QScpMinOrderSettingDO.scpMinOrderSettingDO;
    private static final QScpMinOrderSettingItemDO scpMinOrderSettingItemDO = QScpMinOrderSettingItemDO.scpMinOrderSettingItemDO;
    private final JPAQueryFactory jpaQueryFactory;

    public List<ScpMinOrderSettingItemRespVO> getMinOrderSettingItemByStoreCode(String storeCode, String docType, List<String> itemType2s) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpMinOrderSettingItemRespVO.class,
                        scpMinOrderSettingItemDO.id,
                        scpMinOrderSettingItemDO.masId,
                        scpMinOrderSettingItemDO.itemId,
                        scpMinOrderSettingItemDO.itemCode,
                        scpMinOrderSettingItemDO.itemName,
                        scpMinOrderSettingItemDO.minNum,
                        scpMinOrderSettingItemDO.itemType2,
                        scpMinOrderSettingDO.activityCode
                )).from(scpMinOrderSettingDO)
                .leftJoin(scpMinOrderSettingItemDO).on(scpMinOrderSettingDO.id.eq(scpMinOrderSettingItemDO.masId))
                .leftJoin(scpMinOrderSettingStoreDO).on(scpMinOrderSettingStoreDO.masId.eq(scpMinOrderSettingDO.id));
        jpaQuery.where(scpMinOrderSettingStoreDO.storeCode.eq(storeCode));
        jpaQuery.where(scpMinOrderSettingItemDO.itemType2.in(itemType2s));
        jpaQuery.where(scpMinOrderSettingStoreDO.maxNum.gt(scpMinOrderSettingStoreDO.activeNum));
        jpaQuery.where(scpMinOrderSettingDO.docType.like("%" + docType + "%"));
        jpaQuery.where(scpMinOrderSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime now = LocalDateTime.now();
        jpaQuery.where(scpMinOrderSettingDO.validFrom.loe(now).and(scpMinOrderSettingDO.validTo.goe(now)));
        return jpaQuery.fetch();
    }

    public List<Long> findMasIdByItemId(Long itemId) {
        var jpaQuery = jpaQueryFactory.select(scpMinOrderSettingItemDO.masId).distinct()
                .from(scpMinOrderSettingItemDO);
        jpaQuery.where(scpMinOrderSettingItemDO.itemId.eq(itemId));
        return jpaQuery.fetch();
    }

}
